/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.regionserver.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.ScanWildcardColumnTracker;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestScanWildcardColumnTracker
extends HBaseTestCase {
    static final int VERSIONS = 2;

    public void testCheckColumn_Ok() throws IOException {
        ScanWildcardColumnTracker tracker = new ScanWildcardColumnTracker(0, 2, Long.MIN_VALUE);
        ArrayList<byte[]> qualifiers = new ArrayList<byte[]>();
        qualifiers.add(Bytes.toBytes((String)"qualifer1"));
        qualifiers.add(Bytes.toBytes((String)"qualifer2"));
        qualifiers.add(Bytes.toBytes((String)"qualifer3"));
        qualifiers.add(Bytes.toBytes((String)"qualifer4"));
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>();
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>();
        for (byte[] qualifier : qualifiers) {
            ScanQueryMatcher.MatchCode mc = ScanQueryMatcher.checkColumn((ColumnTracker)tracker, (byte[])qualifier, (int)0, (int)qualifier.length, (long)1L, (byte)KeyValue.Type.Put.getCode(), (boolean)false);
            actual.add(mc);
        }
        for (int i = 0; i < expected.size(); ++i) {
            TestScanWildcardColumnTracker.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testCheckColumn_EnforceVersions() throws IOException {
        ScanWildcardColumnTracker tracker = new ScanWildcardColumnTracker(0, 2, Long.MIN_VALUE);
        ArrayList<byte[]> qualifiers = new ArrayList<byte[]>();
        qualifiers.add(Bytes.toBytes((String)"qualifer1"));
        qualifiers.add(Bytes.toBytes((String)"qualifer1"));
        qualifiers.add(Bytes.toBytes((String)"qualifer1"));
        qualifiers.add(Bytes.toBytes((String)"qualifer2"));
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>();
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>();
        long timestamp = 0L;
        for (byte[] qualifier : qualifiers) {
            ScanQueryMatcher.MatchCode mc = ScanQueryMatcher.checkColumn((ColumnTracker)tracker, (byte[])qualifier, (int)0, (int)qualifier.length, (long)(++timestamp), (byte)KeyValue.Type.Put.getCode(), (boolean)false);
            actual.add(mc);
        }
        for (int i = 0; i < expected.size(); ++i) {
            TestScanWildcardColumnTracker.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void DisabledTestCheckColumn_WrongOrder() {
        ScanWildcardColumnTracker tracker = new ScanWildcardColumnTracker(0, 2, Long.MIN_VALUE);
        ArrayList<byte[]> qualifiers = new ArrayList<byte[]>();
        qualifiers.add(Bytes.toBytes((String)"qualifer2"));
        qualifiers.add(Bytes.toBytes((String)"qualifer1"));
        boolean ok = false;
        try {
            for (byte[] qualifier : qualifiers) {
                ScanQueryMatcher.checkColumn((ColumnTracker)tracker, (byte[])qualifier, (int)0, (int)qualifier.length, (long)1L, (byte)KeyValue.Type.Put.getCode(), (boolean)false);
            }
        }
        catch (Exception e) {
            ok = true;
        }
        TestScanWildcardColumnTracker.assertEquals((boolean)true, (boolean)ok);
    }
}

