/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFlusher;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.HLogSplitter;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestWALReplay {
    public static final Log LOG = LogFactory.getLog(TestWALReplay.class);
    static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final EnvironmentEdge ee = EnvironmentEdgeManager.getDelegate();
    private Path hbaseRootDir = null;
    private String logName;
    private Path oldLogDir;
    private Path logDir;
    private FileSystem fs;
    private Configuration conf;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("dfs.support.append", true);
        conf.setInt("dfs.client.block.recovery.retries", 2);
        TEST_UTIL.startMiniCluster(3);
        Path hbaseRootDir = TEST_UTIL.getDFSCluster().getFileSystem().makeQualified(new Path("/hbase"));
        LOG.info((Object)("hbase.rootdir=" + hbaseRootDir));
        FSUtils.setRootDir((Configuration)conf, (Path)hbaseRootDir);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.conf = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        this.fs = TEST_UTIL.getDFSCluster().getFileSystem();
        this.hbaseRootDir = FSUtils.getRootDir((Configuration)this.conf);
        this.oldLogDir = new Path(this.hbaseRootDir, "oldWALs");
        this.logName = "WALs";
        this.logDir = new Path(this.hbaseRootDir, this.logName);
        if (TEST_UTIL.getDFSCluster().getFileSystem().exists(this.hbaseRootDir)) {
            TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseRootDir, true);
        }
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseRootDir, true);
    }

    private void deleteDir(Path p) throws IOException {
        if (this.fs.exists(p) && !this.fs.delete(p, true)) {
            throw new IOException("Failed remove of " + p);
        }
    }

    @Test
    public void testReplayEditsAfterRegionMovedWithMultiCF() throws Exception {
        int destServerNum;
        TableName tableName = TableName.valueOf((String)"testReplayEditsAfterRegionMovedWithMultiCF");
        byte[] family1 = Bytes.toBytes((String)"cf1");
        byte[] family2 = Bytes.toBytes((String)"cf2");
        byte[] qualifier = Bytes.toBytes((String)"q");
        byte[] value = Bytes.toBytes((String)"testV");
        byte[][] familys = new byte[][]{family1, family2};
        TEST_UTIL.createTable(tableName, (byte[][])familys);
        HTable htable = new HTable(TEST_UTIL.getConfiguration(), tableName);
        Put put = new Put(Bytes.toBytes((String)"r1"));
        put.add(family1, qualifier, value);
        htable.put(put);
        ResultScanner resultScanner = htable.getScanner(new Scan());
        int count = 0;
        while (resultScanner.next() != null) {
            ++count;
        }
        resultScanner.close();
        Assert.assertEquals((long)1L, (long)count);
        MiniHBaseCluster hbaseCluster = TEST_UTIL.getMiniHBaseCluster();
        List<HRegion> regions = hbaseCluster.getRegions(tableName);
        Assert.assertEquals((long)1L, (long)regions.size());
        HRegion destRegion = regions.get(0);
        int originServerNum = hbaseCluster.getServerWith(destRegion.getRegionName());
        Assert.assertTrue((String)"Please start more than 1 regionserver", (hbaseCluster.getRegionServerThreads().size() > 1 ? 1 : 0) != 0);
        for (destServerNum = 0; destServerNum == originServerNum; ++destServerNum) {
        }
        HRegionServer originServer = hbaseCluster.getRegionServer(originServerNum);
        HRegionServer destServer = hbaseCluster.getRegionServer(destServerNum);
        this.moveRegionAndWait(destRegion, destServer);
        Delete del = new Delete(Bytes.toBytes((String)"r1"));
        htable.delete(del);
        resultScanner = htable.getScanner(new Scan());
        count = 0;
        while (resultScanner.next() != null) {
            ++count;
        }
        resultScanner.close();
        Assert.assertEquals((long)0L, (long)count);
        destServer.getOnlineRegion(destRegion.getRegionName()).flushcache();
        for (Store store : destServer.getOnlineRegion(destRegion.getRegionName()).getStores().values()) {
            store.triggerMajorCompaction();
        }
        destServer.getOnlineRegion(destRegion.getRegionName()).compactStores();
        this.moveRegionAndWait(destRegion, originServer);
        originServer.abort("testing");
        Result result = htable.get(new Get(Bytes.toBytes((String)"r1")));
        if (result != null) {
            Assert.assertTrue((String)("Row is deleted, but we get" + result.toString()), (result == null || result.isEmpty() ? 1 : 0) != 0);
        }
        resultScanner.close();
    }

    private void moveRegionAndWait(HRegion destRegion, HRegionServer destServer) throws InterruptedException, MasterNotRunningException, ZooKeeperConnectionException, IOException {
        ServerName serverName;
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        TEST_UTIL.getHBaseAdmin().move(destRegion.getRegionInfo().getEncodedNameAsBytes(), Bytes.toBytes((String)destServer.getServerName().getServerName()));
        while (true) {
            if ((serverName = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(destRegion.getRegionInfo())) != null && serverName.equals((Object)destServer.getServerName())) break;
            Thread.sleep(10L);
        }
        TEST_UTIL.assertRegionOnServer(destRegion.getRegionInfo(), serverName, 200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test2727() throws Exception {
        TableName tableName = TableName.valueOf((String)"test2727");
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        HTableDescriptor htd = this.createBasic3FamilyHTD(tableName);
        HRegion region2 = HRegion.createHRegion((HRegionInfo)hri, (Path)this.hbaseRootDir, (Configuration)this.conf, (HTableDescriptor)htd);
        HRegion.closeHRegion((HRegion)region2);
        byte[] rowName = tableName.getName();
        HLog wal1 = this.createWAL(this.conf);
        int countPerFamily = 1000;
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            this.addWALEdits(tableName, hri, rowName, hcd.getName(), 1000, this.ee, wal1, htd);
        }
        wal1.close();
        this.runWALSplit(this.conf);
        HLog wal2 = this.createWAL(this.conf);
        wal2.setSequenceNumber(wal1.getSequenceNumber());
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            this.addWALEdits(tableName, hri, rowName, hcd.getName(), 1000, this.ee, wal2, htd);
        }
        wal2.close();
        this.runWALSplit(this.conf);
        HLog wal3 = this.createWAL(this.conf);
        wal3.setSequenceNumber(wal2.getSequenceNumber());
        try {
            long wal3SeqId = wal3.getSequenceNumber();
            HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (HLog)wal3);
            long seqid = region.getOpenSeqNum();
            Assert.assertTrue((seqid > wal3SeqId ? 1 : 0) != 0);
            region.close();
        }
        finally {
            wal3.closeAndDelete();
        }
    }

    @Test
    public void testRegionMadeOfBulkLoadedFilesOnly() throws IOException, SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException, InterruptedException {
        TableName tableName = TableName.valueOf((String)"testReplayEditsWrittenViaHRegion");
        final HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = new Path(this.hbaseRootDir, tableName.getNameAsString());
        this.deleteDir(basedir);
        final HTableDescriptor htd = this.createBasic3FamilyHTD(tableName);
        HRegion region2 = HRegion.createHRegion((HRegionInfo)hri, (Path)this.hbaseRootDir, (Configuration)this.conf, (HTableDescriptor)htd);
        HRegion.closeHRegion((HRegion)region2);
        HLog wal = this.createWAL(this.conf);
        HRegion region = HRegion.openHRegion((HRegionInfo)hri, (HTableDescriptor)htd, (HLog)wal, (Configuration)this.conf);
        Path f = new Path(basedir, "hfile");
        HFile.Writer writer = HFile.getWriterFactoryNoCache((Configuration)this.conf).withPath(this.fs, f).create();
        byte[] family = ((HColumnDescriptor)htd.getFamilies().iterator().next()).getName();
        byte[] row = tableName.getName();
        writer.append(new KeyValue(row, family, family, row));
        writer.close();
        ArrayList<Pair> hfs = new ArrayList<Pair>(1);
        hfs.add(Pair.newPair((Object)family, (Object)f.toString()));
        region.bulkLoadHFiles(hfs, true);
        region.put(new Put(row).add(family, family, family));
        wal.sync();
        final Configuration newConf = HBaseConfiguration.create((Configuration)this.conf);
        User user = HBaseTestingUtility.getDifferentUser(newConf, tableName.getNameAsString());
        user.runAs(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                TestWALReplay.this.runWALSplit(newConf);
                HLog wal2 = TestWALReplay.this.createWAL(newConf);
                HRegion region2 = HRegion.openHRegion((Configuration)newConf, (FileSystem)FileSystem.get((Configuration)newConf), (Path)TestWALReplay.this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (HLog)wal2);
                long seqid2 = region2.getOpenSeqNum();
                Assert.assertTrue((seqid2 > -1L ? 1 : 0) != 0);
                region2.close();
                wal2.closeAndDelete();
                return null;
            }
        });
    }

    @Test
    public void testReplayEditsWrittenViaHRegion() throws IOException, SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException, InterruptedException {
        TableName tableName = TableName.valueOf((String)"testReplayEditsWrittenViaHRegion");
        final HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        final Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        byte[] rowName = tableName.getName();
        int countPerFamily = 10;
        final HTableDescriptor htd = this.createBasic3FamilyHTD(tableName);
        HRegion region3 = HRegion.createHRegion((HRegionInfo)hri, (Path)this.hbaseRootDir, (Configuration)this.conf, (HTableDescriptor)htd);
        HRegion.closeHRegion((HRegion)region3);
        HLog wal = this.createWAL(this.conf);
        HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (HLog)wal);
        long seqid = region.getOpenSeqNum();
        wal.setSequenceNumber(seqid);
        boolean first = true;
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            this.addRegionEdits(rowName, hcd.getName(), 10, this.ee, region, "x");
            if (!first) continue;
            region.flushcache();
            first = false;
        }
        final Get g = new Get(rowName);
        Result result = region.get(g);
        Assert.assertEquals((long)(10 * htd.getFamilies().size()), (long)result.size());
        region.close(true);
        wal.close();
        this.runWALSplit(this.conf);
        HLog wal2 = this.createWAL(this.conf);
        HRegion region2 = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (HLog)wal2);
        long seqid2 = region2.getOpenSeqNum();
        wal2.setSequenceNumber(seqid2);
        Assert.assertTrue((seqid + (long)result.size() < seqid2 ? 1 : 0) != 0);
        Result result1b = region2.get(g);
        Assert.assertEquals((long)result.size(), (long)result1b.size());
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            this.addRegionEdits(rowName, hcd.getName(), 10, this.ee, region2, "y");
        }
        final Result result2 = region2.get(g);
        Assert.assertEquals((long)(2 * result.size()), (long)result2.size());
        wal2.sync();
        HBaseTestingUtility.setMaxRecoveryErrorCount(((FSHLog)wal2).getOutputStream(), 1);
        final Configuration newConf = HBaseConfiguration.create((Configuration)this.conf);
        User user = HBaseTestingUtility.getDifferentUser(newConf, tableName.getNameAsString());
        user.runAs(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                TestWALReplay.this.runWALSplit(newConf);
                FileSystem newFS = FileSystem.get((Configuration)newConf);
                HLog wal3 = TestWALReplay.this.createWAL(newConf);
                final AtomicInteger countOfRestoredEdits = new AtomicInteger(0);
                HRegion region3 = new HRegion(basedir, wal3, newFS, newConf, hri, htd, null){

                    protected boolean restoreEdit(Store s, KeyValue kv) {
                        boolean b = super.restoreEdit(s, kv);
                        countOfRestoredEdits.incrementAndGet();
                        return b;
                    }
                };
                long seqid3 = region3.initialize();
                wal3.setSequenceNumber(seqid3);
                Result result3 = region3.get(g);
                Assert.assertEquals((long)result2.size(), (long)result3.size());
                Assert.assertEquals((long)(htd.getFamilies().size() * 10), (long)countOfRestoredEdits.get());
                region3.close();
                wal3.closeAndDelete();
                return null;
            }
        });
    }

    @Test
    public void testReplayEditsAfterPartialFlush() throws IOException, SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException, InterruptedException {
        TableName tableName = TableName.valueOf((String)"testReplayEditsWrittenViaHRegion");
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        byte[] rowName = tableName.getName();
        int countPerFamily = 10;
        HTableDescriptor htd = this.createBasic3FamilyHTD(tableName);
        HRegion region3 = HRegion.createHRegion((HRegionInfo)hri, (Path)this.hbaseRootDir, (Configuration)this.conf, (HTableDescriptor)htd);
        HRegion.closeHRegion((HRegion)region3);
        HLog wal = this.createWAL(this.conf);
        HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (HLog)wal);
        long seqid = region.getOpenSeqNum();
        wal.setSequenceNumber(seqid);
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            this.addRegionEdits(rowName, hcd.getName(), 10, this.ee, region, "x");
        }
        Get g = new Get(rowName);
        Result result = region.get(g);
        Assert.assertEquals((long)(10 * htd.getFamilies().size()), (long)result.size());
        region.flushcache();
        region.close(true);
        wal.close();
        int cf_count = 0;
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            if (++cf_count != 2) continue;
            region.getRegionFileSystem().deleteFamily(hcd.getNameAsString());
        }
        this.runWALSplit(this.conf);
        HLog wal2 = this.createWAL(this.conf);
        HRegion region2 = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (HLog)wal2);
        long seqid2 = region2.getOpenSeqNum();
        wal2.setSequenceNumber(seqid2);
        Assert.assertTrue((seqid + (long)result.size() < seqid2 ? 1 : 0) != 0);
        Result result1b = region2.get(g);
        Assert.assertEquals((long)result.size(), (long)result1b.size());
    }

    @Test
    public void testReplayEditsAfterAbortingFlush() throws IOException {
        TableName tableName = TableName.valueOf((String)"testReplayEditsAfterAbortingFlush");
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        HTableDescriptor htd = this.createBasic3FamilyHTD(tableName);
        HRegion region3 = HRegion.createHRegion((HRegionInfo)hri, (Path)this.hbaseRootDir, (Configuration)this.conf, (HTableDescriptor)htd);
        region3.close();
        region3.getLog().closeAndDelete();
        HLog wal = this.createWAL(this.conf);
        RegionServerServices rsServices = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        ((RegionServerServices)Mockito.doReturn((Object)false).when((Object)rsServices)).isAborted();
        Configuration customConf = new Configuration(this.conf);
        customConf.set("hbase.hstore.defaultengine.storeflusher.class", CustomStoreFlusher.class.getName());
        HRegion region = new HRegion(basedir, wal, this.fs, customConf, hri, htd, rsServices);
        long seqid = region.initialize();
        wal.setSequenceNumber(seqid);
        int writtenRowCount = 10;
        ArrayList families = new ArrayList(htd.getFamilies());
        for (int i = 0; i < writtenRowCount; ++i) {
            Put put = new Put(Bytes.toBytes((String)(tableName + Integer.toString(i))));
            put.add(((HColumnDescriptor)families.get(i % families.size())).getName(), Bytes.toBytes((String)"q"), Bytes.toBytes((String)"val"));
            region.put(put);
        }
        RegionScanner scanner = region.getScanner(new Scan());
        Assert.assertEquals((long)writtenRowCount, (long)this.getScannedCount(scanner));
        CustomStoreFlusher.throwExceptionWhenFlushing.set(true);
        try {
            region.flushcache();
            Assert.fail((String)"Injected exception hasn't been thrown");
        }
        catch (Throwable t) {
            LOG.info((Object)("Expected simulated exception when flushing region," + t.getMessage()));
            ((RegionServerServices)Mockito.doReturn((Object)true).when((Object)rsServices)).isAborted();
        }
        int moreRow = 10;
        for (int i = writtenRowCount; i < writtenRowCount + moreRow; ++i) {
            Put put = new Put(Bytes.toBytes((String)(tableName + Integer.toString(i))));
            put.add(((HColumnDescriptor)families.get(i % families.size())).getName(), Bytes.toBytes((String)"q"), Bytes.toBytes((String)"val"));
            region.put(put);
        }
        writtenRowCount += moreRow;
        CustomStoreFlusher.throwExceptionWhenFlushing.set(false);
        try {
            region.flushcache();
        }
        catch (IOException t) {
            LOG.info((Object)("Expected exception when flushing region because server is stopped," + t.getMessage()));
        }
        region.close(true);
        wal.close();
        this.runWALSplit(this.conf);
        HLog wal2 = this.createWAL(this.conf);
        ((RegionServerServices)Mockito.doReturn((Object)false).when((Object)rsServices)).isAborted();
        HRegion region2 = new HRegion(basedir, wal2, this.fs, this.conf, hri, htd, rsServices);
        long seqid2 = region2.initialize();
        wal2.setSequenceNumber(seqid2);
        scanner = region2.getScanner(new Scan());
        Assert.assertEquals((long)writtenRowCount, (long)this.getScannedCount(scanner));
    }

    private int getScannedCount(RegionScanner scanner) throws IOException {
        int scannedCount = 0;
        ArrayList results = new ArrayList();
        while (true) {
            boolean existMore = scanner.next(results);
            if (!results.isEmpty()) {
                ++scannedCount;
            }
            if (!existMore) break;
            results.clear();
        }
        return scannedCount;
    }

    @Test
    public void testReplayEditsWrittenIntoWAL() throws Exception {
        TableName tableName = TableName.valueOf((String)"testReplayEditsWrittenIntoWAL");
        final HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        final Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        final HTableDescriptor htd = this.createBasic3FamilyHTD(tableName);
        HRegion region2 = HRegion.createHRegion((HRegionInfo)hri, (Path)this.hbaseRootDir, (Configuration)this.conf, (HTableDescriptor)htd);
        HRegion.closeHRegion((HRegion)region2);
        final HLog wal = this.createWAL(this.conf);
        final byte[] rowName = tableName.getName();
        byte[] regionName = hri.getEncodedNameAsBytes();
        int countPerFamily = 1000;
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            this.addWALEdits(tableName, hri, rowName, hcd.getName(), 1000, this.ee, wal, htd);
        }
        wal.startCacheFlush(regionName);
        wal.completeCacheFlush(regionName);
        WALEdit edit = new WALEdit();
        long now = this.ee.currentTimeMillis();
        edit.add(new KeyValue(rowName, Bytes.toBytes((String)"another family"), rowName, now, rowName));
        wal.append(hri, tableName, edit, now, htd);
        edit = new WALEdit();
        now = this.ee.currentTimeMillis();
        edit.add(new KeyValue(rowName, Bytes.toBytes((String)"c"), null, now, KeyValue.Type.DeleteFamily));
        wal.append(hri, tableName, edit, now, htd);
        wal.sync();
        HBaseTestingUtility.setMaxRecoveryErrorCount(((FSHLog)wal).getOutputStream(), 1);
        final Configuration newConf = HBaseConfiguration.create((Configuration)this.conf);
        User user = HBaseTestingUtility.getDifferentUser(newConf, ".replay.wal.secondtime");
        user.runAs(new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                TestWALReplay.this.runWALSplit(newConf);
                FileSystem newFS = FileSystem.get((Configuration)newConf);
                newConf.setInt("hbase.hregion.memstore.flush.size", 102400);
                HLog newWal = TestWALReplay.this.createWAL(newConf);
                final AtomicInteger flushcount = new AtomicInteger(0);
                try {
                    HRegion region = new HRegion(basedir, newWal, newFS, newConf, hri, htd, null){

                        protected boolean internalFlushcache(HLog wal, long myseqid, MonitoredTask status) throws IOException {
                            LOG.info((Object)"InternalFlushCache Invoked");
                            boolean b = super.internalFlushcache(wal, myseqid, (MonitoredTask)Mockito.mock(MonitoredTask.class));
                            flushcount.incrementAndGet();
                            return b;
                        }
                    };
                    long seqid = region.initialize();
                    Assert.assertTrue((String)("Flushcount=" + flushcount.get()), (flushcount.get() > 0 ? 1 : 0) != 0);
                    Assert.assertTrue((seqid > wal.getSequenceNumber() ? 1 : 0) != 0);
                    Get get = new Get(rowName);
                    Result result = region.get(get);
                    Assert.assertEquals((long)(1000 * (htd.getFamilies().size() - 1)), (long)result.size());
                    region.close();
                }
                finally {
                    newWal.closeAndDelete();
                }
                return null;
            }
        });
    }

    @Test
    public void testSequentialEditLogSeqNum() throws IOException {
        TableName tableName = TableName.valueOf((String)"testSequentialEditLogSeqNum");
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        byte[] rowName = tableName.getName();
        int countPerFamily = 10;
        HTableDescriptor htd = this.createBasic1FamilyHTD(tableName);
        MockHLog wal = this.createMockWAL(this.conf);
        HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (HLog)wal);
        long seqid = region.getOpenSeqNum();
        wal.setSequenceNumber(seqid);
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            this.addRegionEdits(rowName, hcd.getName(), 10, this.ee, region, "x");
        }
        long sequenceNumber = wal.getSequenceNumber();
        region.flushcache();
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            this.addRegionEdits(rowName, hcd.getName(), 5, this.ee, region, "x");
        }
        long lastestSeqNumber = wal.getSequenceNumber();
        wal.doCompleteCacheFlush = true;
        wal.completeCacheFlush(hri.getEncodedNameAsBytes());
        wal.close();
        FileStatus[] listStatus = this.fs.listStatus(wal.getDir());
        HLogSplitter.splitLogFile((Path)this.hbaseRootDir, (FileStatus)listStatus[0], (FileSystem)this.fs, (Configuration)this.conf, null, null, null);
        FileStatus[] listStatus1 = this.fs.listStatus(new Path(FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName), new Path(hri.getEncodedName(), "recovered.edits")));
        int editCount = 0;
        for (FileStatus fileStatus : listStatus1) {
            editCount = Integer.parseInt(fileStatus.getPath().getName());
        }
        Assert.assertEquals((String)"The sequence number of the recoverd.edits and the current edit seq should be same", (long)lastestSeqNumber, (long)editCount);
    }

    private HTableDescriptor createBasic1FamilyHTD(TableName tableName) {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        HColumnDescriptor a = new HColumnDescriptor(Bytes.toBytes((String)"a"));
        htd.addFamily(a);
        return htd;
    }

    private MockHLog createMockWAL(Configuration conf) throws IOException {
        MockHLog wal = new MockHLog(FileSystem.get((Configuration)conf), this.hbaseRootDir, this.logName, conf);
        HBaseTestingUtility.setMaxRecoveryErrorCount(wal.getOutputStream(), 1);
        return wal;
    }

    private void addWALEdits(TableName tableName, HRegionInfo hri, byte[] rowName, byte[] family, int count, EnvironmentEdge ee, HLog wal, HTableDescriptor htd) throws IOException {
        String familyStr = Bytes.toString((byte[])family);
        for (int j = 0; j < count; ++j) {
            byte[] qualifierBytes = Bytes.toBytes((String)Integer.toString(j));
            byte[] columnBytes = Bytes.toBytes((String)(familyStr + ":" + Integer.toString(j)));
            WALEdit edit = new WALEdit();
            edit.add(new KeyValue(rowName, family, qualifierBytes, ee.currentTimeMillis(), columnBytes));
            wal.append(hri, tableName, edit, ee.currentTimeMillis(), htd);
        }
    }

    private void addRegionEdits(byte[] rowName, byte[] family, int count, EnvironmentEdge ee, HRegion r, String qualifierPrefix) throws IOException {
        for (int j = 0; j < count; ++j) {
            byte[] qualifier = Bytes.toBytes((String)(qualifierPrefix + Integer.toString(j)));
            Put p = new Put(rowName);
            p.add(family, qualifier, ee.currentTimeMillis(), rowName);
            r.put(p);
        }
    }

    private HRegionInfo createBasic3FamilyHRegionInfo(TableName tableName) {
        return new HRegionInfo(tableName, null, null, false);
    }

    private Path runWALSplit(Configuration c) throws IOException {
        List splits = HLogSplitter.split((Path)this.hbaseRootDir, (Path)this.logDir, (Path)this.oldLogDir, (FileSystem)FileSystem.get((Configuration)c), (Configuration)c);
        Assert.assertEquals((String)("splits=" + splits), (long)1L, (long)splits.size());
        Assert.assertTrue((boolean)this.fs.exists((Path)splits.get(0)));
        LOG.info((Object)("Split file=" + splits.get(0)));
        return (Path)splits.get(0);
    }

    private HLog createWAL(Configuration c) throws IOException {
        HLog wal = HLogFactory.createHLog((FileSystem)FileSystem.get((Configuration)c), (Path)this.hbaseRootDir, (String)this.logName, (Configuration)c);
        HBaseTestingUtility.setMaxRecoveryErrorCount(((FSHLog)wal).getOutputStream(), 1);
        return wal;
    }

    private HTableDescriptor createBasic3FamilyHTD(TableName tableName) {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        HColumnDescriptor a = new HColumnDescriptor(Bytes.toBytes((String)"a"));
        htd.addFamily(a);
        HColumnDescriptor b = new HColumnDescriptor(Bytes.toBytes((String)"b"));
        htd.addFamily(b);
        HColumnDescriptor c = new HColumnDescriptor(Bytes.toBytes((String)"c"));
        htd.addFamily(c);
        return htd;
    }

    class TestFlusher
    implements FlushRequester {
        private HRegion r;

        TestFlusher() {
        }

        public void requestFlush(HRegion region) {
            try {
                this.r.flushcache();
            }
            catch (IOException e) {
                throw new RuntimeException("Exception flushing", e);
            }
        }

        public void requestDelayedFlush(HRegion region, long when) {
        }
    }

    static class MockHLog
    extends FSHLog {
        boolean doCompleteCacheFlush = false;

        public MockHLog(FileSystem fs, Path rootDir, String logName, Configuration conf) throws IOException {
            super(fs, rootDir, logName, conf);
        }

        public void completeCacheFlush(byte[] encodedRegionName) {
            if (!this.doCompleteCacheFlush) {
                return;
            }
            super.completeCacheFlush(encodedRegionName);
        }
    }

    public static class CustomStoreFlusher
    extends DefaultStoreFlusher {
        static final AtomicBoolean throwExceptionWhenFlushing = new AtomicBoolean(false);

        public CustomStoreFlusher(Configuration conf, Store store) {
            super(conf, store);
        }

        public List<Path> flushSnapshot(SortedSet<KeyValue> snapshot, long cacheFlushId, TimeRangeTracker snapshotTimeRangeTracker, AtomicLong flushedSize, MonitoredTask status) throws IOException {
            if (throwExceptionWhenFlushing.get()) {
                throw new IOException("Simulated exception by tests");
            }
            return super.flushSnapshot(snapshot, cacheFlushId, snapshotTimeRangeTracker, flushedSize, status);
        }
    }
}

