/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.snapshot.ExportSnapshot;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestExportSnapshot {
    private final Log LOG = LogFactory.getLog(this.getClass());
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    private byte[] emptySnapshotName;
    private byte[] snapshotName;
    private TableName tableName;
    private HBaseAdmin admin;

    public static void setUpBaseConf(Configuration conf) {
        conf.setBoolean("hbase.snapshot.enabled", true);
        conf.setInt("hbase.regionserver.msginterval", 100);
        conf.setInt("hbase.client.pause", 250);
        conf.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, 6);
        conf.setBoolean("hbase.master.enabletable.roundrobin", true);
        conf.setInt("mapreduce.map.max.attempts", 10);
        conf.setInt("mapred.map.max.attempts", 10);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestExportSnapshot.setUpBaseConf(TEST_UTIL.getConfiguration());
        TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.startMiniMapReduceCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniMapReduceCluster();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.admin = TEST_UTIL.getHBaseAdmin();
        long tid = System.currentTimeMillis();
        this.tableName = TableName.valueOf((String)("testtb-" + tid));
        this.snapshotName = Bytes.toBytes((String)("snaptb0-" + tid));
        this.emptySnapshotName = Bytes.toBytes((String)("emptySnaptb0-" + tid));
        SnapshotTestingUtils.createTable(TEST_UTIL, this.tableName, new byte[][]{FAMILY});
        this.admin.snapshot(this.emptySnapshotName, this.tableName);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), this.tableName);
        SnapshotTestingUtils.loadData(TEST_UTIL, this.tableName, 1000, (byte[][])new byte[][]{FAMILY});
        this.admin.snapshot(this.snapshotName, this.tableName);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.deleteTable(this.tableName);
        SnapshotTestingUtils.deleteAllSnapshots(TEST_UTIL.getHBaseAdmin());
        SnapshotTestingUtils.deleteArchiveDirectory(TEST_UTIL);
    }

    @Test
    public void testBalanceSplit() throws Exception {
        ArrayList<Pair> files = new ArrayList<Pair>();
        for (long i = 0L; i <= 20L; ++i) {
            files.add(new Pair((Object)new Path("file-" + i), (Object)i));
        }
        List splits = ExportSnapshot.getBalancedSplits(files, (int)5);
        Assert.assertEquals((long)5L, (long)splits.size());
        Assert.assertEquals(Arrays.asList(new Path("file-20"), new Path("file-11"), new Path("file-10"), new Path("file-1"), new Path("file-0")), splits.get(0));
        Assert.assertEquals(Arrays.asList(new Path("file-19"), new Path("file-12"), new Path("file-9"), new Path("file-2")), splits.get(1));
        Assert.assertEquals(Arrays.asList(new Path("file-18"), new Path("file-13"), new Path("file-8"), new Path("file-3")), splits.get(2));
        Assert.assertEquals(Arrays.asList(new Path("file-17"), new Path("file-14"), new Path("file-7"), new Path("file-4")), splits.get(3));
        Assert.assertEquals(Arrays.asList(new Path("file-16"), new Path("file-15"), new Path("file-6"), new Path("file-5")), splits.get(4));
    }

    @Test
    public void testExportFileSystemState() throws Exception {
        this.testExportFileSystemState(this.tableName, this.snapshotName, 2);
    }

    @Test
    public void testEmptyExportFileSystemState() throws Exception {
        this.testExportFileSystemState(this.tableName, this.emptySnapshotName, 1);
    }

    @Test
    public void testConsecutiveExports() throws Exception {
        Path copyDir = this.getLocalDestinationDir();
        this.testExportFileSystemState(this.tableName, this.snapshotName, 2, copyDir, false);
        this.testExportFileSystemState(this.tableName, this.snapshotName, 2, copyDir, true);
        this.removeExportDir(copyDir);
    }

    @Test
    public void testSnapshotWithRefsExportFileSystemState() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        TableName tableWithRefsName = TableName.valueOf((String)"tableWithRefs");
        String snapshotName = "tableWithRefs";
        String TEST_FAMILY = Bytes.toString((byte[])FAMILY);
        String TEST_HFILE = "abc";
        HBaseProtos.SnapshotDescription sd = HBaseProtos.SnapshotDescription.newBuilder().setName("tableWithRefs").setTable(tableWithRefsName.getNameAsString()).build();
        FileSystem fs = TEST_UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
        Path rootDir = TEST_UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        Path archiveDir = new Path(rootDir, "archive");
        HRegionInfo hri = new HRegionInfo(tableWithRefsName);
        HRegionFileSystem r0fs = HRegionFileSystem.createRegionOnFileSystem((Configuration)conf, (FileSystem)fs, (Path)FSUtils.getTableDir((Path)archiveDir, (TableName)hri.getTable()), (HRegionInfo)hri);
        Path storeFile = new Path(rootDir, "abc");
        FSDataOutputStream out = fs.create(storeFile);
        out.write(Bytes.toBytes((String)"Test Data"));
        out.close();
        r0fs.commitStoreFile(TEST_FAMILY, storeFile);
        hri = new HRegionInfo(tableWithRefsName);
        HRegionFileSystem r1fs = HRegionFileSystem.createRegionOnFileSystem((Configuration)conf, (FileSystem)fs, (Path)new Path(archiveDir, hri.getTable().getNameAsString()), (HRegionInfo)hri);
        storeFile = new Path(rootDir, "abc." + r0fs.getRegionInfo().getEncodedName());
        out = fs.create(storeFile);
        out.write(Bytes.toBytes((String)"Test Data"));
        out.close();
        r1fs.commitStoreFile(TEST_FAMILY, storeFile);
        Path tableDir = FSUtils.getTableDir((Path)archiveDir, (TableName)tableWithRefsName);
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)"tableWithRefs", (Path)rootDir);
        FileUtil.copy((FileSystem)fs, (Path)tableDir, (FileSystem)fs, (Path)snapshotDir, (boolean)false, (Configuration)conf);
        SnapshotDescriptionUtils.writeSnapshotInfo((HBaseProtos.SnapshotDescription)sd, (Path)snapshotDir, (FileSystem)fs);
        this.testExportFileSystemState(tableWithRefsName, Bytes.toBytes((String)"tableWithRefs"), 2);
    }

    private void testExportFileSystemState(TableName tableName, byte[] snapshotName, int filesExpected) throws Exception {
        Path copyDir = this.getHdfsDestinationDir();
        this.testExportFileSystemState(tableName, snapshotName, filesExpected, copyDir, false);
        this.removeExportDir(copyDir);
    }

    private void testExportFileSystemState(TableName tableName, byte[] snapshotName, int filesExpected, Path copyDir, boolean overwrite) throws Exception {
        URI hdfsUri = FileSystem.get((Configuration)TEST_UTIL.getConfiguration()).getUri();
        FileSystem fs = FileSystem.get((URI)copyDir.toUri(), (Configuration)new Configuration());
        copyDir = copyDir.makeQualified(fs);
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("-snapshot");
        opts.add(Bytes.toString((byte[])snapshotName));
        opts.add("-copy-to");
        opts.add(copyDir.toString());
        if (overwrite) {
            opts.add("-overwrite");
        }
        int res = ExportSnapshot.innerMain((Configuration)TEST_UTIL.getConfiguration(), (String[])opts.toArray(new String[opts.size()]));
        Assert.assertEquals((long)0L, (long)res);
        FileStatus[] rootFiles = fs.listStatus(copyDir);
        Assert.assertEquals((long)filesExpected, (long)rootFiles.length);
        for (FileStatus fileStatus : rootFiles) {
            String name = fileStatus.getPath().getName();
            Assert.assertTrue((boolean)fileStatus.isDir());
            Assert.assertTrue((name.equals(".hbase-snapshot") || name.equals("archive") ? 1 : 0) != 0);
        }
        FileSystem hdfs = FileSystem.get((URI)hdfsUri, (Configuration)TEST_UTIL.getConfiguration());
        Path snapshotDir = new Path(".hbase-snapshot", Bytes.toString((byte[])snapshotName));
        this.verifySnapshot(hdfs, new Path(TEST_UTIL.getDefaultRootDirPath(), snapshotDir), fs, new Path(copyDir, snapshotDir));
        this.verifyArchive(fs, copyDir, tableName, Bytes.toString((byte[])snapshotName));
        FSUtils.logFileSystemState((FileSystem)hdfs, (Path)snapshotDir, (Log)this.LOG);
    }

    @Test
    public void testExportFailure() throws Exception {
        Assert.assertEquals((long)1L, (long)this.runExportAndInjectFailures(this.snapshotName, false));
    }

    @Test
    public void testExportRetry() throws Exception {
        Assert.assertEquals((long)0L, (long)this.runExportAndInjectFailures(this.snapshotName, true));
    }

    private int runExportAndInjectFailures(byte[] snapshotName, boolean retry) throws Exception {
        Path copyDir = this.getLocalDestinationDir();
        URI hdfsUri = FileSystem.get((Configuration)TEST_UTIL.getConfiguration()).getUri();
        FileSystem fs = FileSystem.get((URI)copyDir.toUri(), (Configuration)new Configuration());
        copyDir = copyDir.makeQualified(fs);
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setBoolean("test.snapshot.export.failure", true);
        conf.setBoolean("test.snapshot.export.failure.retry", retry);
        int res = ExportSnapshot.innerMain((Configuration)conf, (String[])new String[]{"-snapshot", Bytes.toString((byte[])snapshotName), "-copy-to", copyDir.toString()});
        return res;
    }

    private void verifySnapshot(FileSystem fs1, Path root1, FileSystem fs2, Path root2) throws IOException {
        HashSet s = new HashSet();
        Assert.assertEquals(this.listFiles(fs1, root1, root1), this.listFiles(fs2, root2, root2));
    }

    private void verifyArchive(final FileSystem fs, Path rootDir, final TableName tableName, String snapshotName) throws IOException {
        final Path exportedSnapshot = new Path(rootDir, new Path(".hbase-snapshot", snapshotName));
        final Path exportedArchive = new Path(rootDir, "archive");
        this.LOG.debug(this.listFiles(fs, exportedArchive, exportedArchive));
        SnapshotReferenceUtil.visitReferencedFiles((FileSystem)fs, (Path)exportedSnapshot, (SnapshotReferenceUtil.FileVisitor)new SnapshotReferenceUtil.FileVisitor(){

            public void storeFile(String region, String family, String hfile) throws IOException {
                this.verifyNonEmptyFile(new Path(exportedArchive, new Path(FSUtils.getTableDir((Path)new Path("./"), (TableName)tableName), new Path(region, new Path(family, hfile)))));
            }

            public void recoveredEdits(String region, String logfile) throws IOException {
                this.verifyNonEmptyFile(new Path(exportedSnapshot, new Path(tableName.getNameAsString(), new Path(region, logfile))));
            }

            public void logFile(String server, String logfile) throws IOException {
                this.verifyNonEmptyFile(new Path(exportedSnapshot, new Path(server, logfile)));
            }

            private void verifyNonEmptyFile(Path path) throws IOException {
                Assert.assertTrue((String)(path + " should exists"), (boolean)fs.exists(path));
                Assert.assertTrue((String)(path + " should not be empty"), (fs.getFileStatus(path).getLen() > 0L ? 1 : 0) != 0);
            }
        });
    }

    private Set<String> listFiles(FileSystem fs, Path root, Path dir) throws IOException {
        HashSet<String> files = new HashSet<String>();
        int rootPrefix = root.toString().length();
        FileStatus[] list = FSUtils.listStatus((FileSystem)fs, (Path)dir);
        if (list != null) {
            for (FileStatus fstat : list) {
                this.LOG.debug((Object)fstat.getPath());
                if (fstat.isDir()) {
                    files.addAll(this.listFiles(fs, root, fstat.getPath()));
                    continue;
                }
                files.add(fstat.getPath().toString().substring(rootPrefix));
            }
        }
        return files;
    }

    private Path getHdfsDestinationDir() {
        Path rootDir = TEST_UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        Path path = new Path(new Path(rootDir, "export-test"), "export-" + System.currentTimeMillis());
        this.LOG.info((Object)("HDFS export destination path: " + path));
        return path;
    }

    private Path getLocalDestinationDir() {
        Path path = TEST_UTIL.getDataTestDir("local-export-" + System.currentTimeMillis());
        this.LOG.info((Object)("Local export destination path: " + path));
        return path;
    }

    private void removeExportDir(Path path) throws IOException {
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)new Configuration());
        FSUtils.logFileSystemState((FileSystem)fs, (Path)path, (Log)this.LOG);
        fs.delete(path, true);
    }
}

