/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.trace;

import com.google.common.collect.Multimap;
import java.util.Collection;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.cloudera.htrace.Sampler;
import org.cloudera.htrace.Span;
import org.cloudera.htrace.SpanReceiver;
import org.cloudera.htrace.Trace;
import org.cloudera.htrace.TraceScope;
import org.cloudera.htrace.TraceTree;
import org.cloudera.htrace.impl.POJOSpanReceiver;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestHTraceHooks {
    private static final byte[] FAMILY_BYTES = "family".getBytes();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final POJOSpanReceiver rcvr = new POJOSpanReceiver();

    @BeforeClass
    public static void before() throws Exception {
        TEST_UTIL.startMiniCluster(2, 3);
        Trace.addReceiver((SpanReceiver)rcvr);
    }

    @AfterClass
    public static void after() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        Trace.removeReceiver((SpanReceiver)rcvr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTraceCreateTable() throws Exception {
        HTable table;
        TraceScope tableCreationSpan = Trace.startSpan((String)"creating table", (Sampler)Sampler.ALWAYS);
        try {
            table = TEST_UTIL.createTable("table".getBytes(), FAMILY_BYTES);
        }
        finally {
            tableCreationSpan.close();
        }
        TEST_UTIL.waitFor(1000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return rcvr.getSpans().size() >= 5;
            }
        });
        Collection spans = rcvr.getSpans();
        TraceTree traceTree = new TraceTree(spans);
        Collection roots = traceTree.getRoots();
        Assert.assertEquals((long)1L, (long)roots.size());
        Span createTableRoot = (Span)roots.iterator().next();
        Assert.assertEquals((Object)"creating table", (Object)createTableRoot.getDescription());
        Multimap spansByParentIdMap = traceTree.getSpansByParentIdMap();
        int createTableCount = 0;
        for (Span s : spansByParentIdMap.get((Object)createTableRoot.getSpanId())) {
            if (!s.getDescription().startsWith("MasterService.CreateTable")) continue;
            ++createTableCount;
        }
        Assert.assertTrue((createTableCount >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((spansByParentIdMap.get((Object)createTableRoot.getSpanId()).size() > 3 ? 1 : 0) != 0);
        Assert.assertTrue((spans.size() > 5 ? 1 : 0) != 0);
        Put put = new Put("row".getBytes());
        put.add(FAMILY_BYTES, "col".getBytes(), "value".getBytes());
        TraceScope putSpan = Trace.startSpan((String)"doing put", (Sampler)Sampler.ALWAYS);
        try {
            table.put(put);
        }
        finally {
            putSpan.close();
        }
        spans = rcvr.getSpans();
        traceTree = new TraceTree(spans);
        roots = traceTree.getRoots();
        Assert.assertEquals((long)2L, (long)roots.size());
        Span putRoot = null;
        for (Span root : roots) {
            if (!root.getDescription().equals("doing put")) continue;
            putRoot = root;
        }
        Assert.assertNotNull(putRoot);
    }
}

