/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import org.kitesdk.data.CompressionType;
import org.kitesdk.data.Format;
import org.kitesdk.data.Formats;
import org.kitesdk.data.PartitionExpression;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.impl.Accessor;

final class AccessorImpl
extends Accessor {
    AccessorImpl() {
    }

    @Override
    public Format newFormat(String name) {
        try {
            return Formats.fromString(name);
        }
        catch (IllegalArgumentException ex) {
            return new Format(name, CompressionType.Uncompressed, new CompressionType[]{CompressionType.Uncompressed});
        }
    }

    @Override
    public PartitionStrategy getSubpartitionStrategy(PartitionStrategy partitionStrategy, int startIndex) {
        return partitionStrategy.getSubpartitionStrategy(startIndex);
    }

    @Override
    public String toExpression(PartitionStrategy partitionStrategy) {
        return PartitionExpression.toExpression(partitionStrategy);
    }

    @Override
    public PartitionStrategy fromExpression(String partitionExpression) {
        return new PartitionExpression(partitionExpression, true).evaluate();
    }
}

