/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.data.FieldMapping;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.spi.ColumnMappingParser;

@Immutable
public class ColumnMapping {
    private final Collection<FieldMapping> fieldMappings;

    private ColumnMapping(Collection<FieldMapping> mappings) {
        this.fieldMappings = ImmutableList.copyOf(mappings);
    }

    public Collection<FieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public FieldMapping getFieldMapping(String fieldName) {
        for (FieldMapping fm : this.fieldMappings) {
            if (!fm.getFieldName().equals(fieldName)) continue;
            return fm;
        }
        return null;
    }

    public Set<String> getRequiredColumns() {
        HashSet<String> set = new HashSet<String>();
        for (FieldMapping fieldMapping : this.fieldMappings) {
            if (FieldMapping.MappingType.KEY == fieldMapping.getMappingType()) continue;
            if (FieldMapping.MappingType.KEY_AS_COLUMN == fieldMapping.getMappingType()) {
                set.add(fieldMapping.getFamilyAsString() + ":");
                continue;
            }
            set.add(fieldMapping.getFamilyAsString() + ":" + fieldMapping.getQualifierAsString());
        }
        return set;
    }

    public Set<String> getRequiredColumnFamilies() {
        HashSet<String> set = new HashSet<String>();
        for (FieldMapping mapping : this.fieldMappings) {
            if (FieldMapping.MappingType.KEY == mapping.getMappingType()) continue;
            set.add(mapping.getFamilyAsString());
        }
        return set;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnMapping that = (ColumnMapping)o;
        return Objects.equal(this.fieldMappings, that.fieldMappings);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fieldMappings.hashCode()});
    }

    public String toString() {
        return ColumnMappingParser.toString(this, false);
    }

    public String toString(boolean pretty) {
        return ColumnMappingParser.toString(this, pretty);
    }

    public static class Builder {
        boolean hasOCCVersion = false;
        boolean hasCounter = false;
        private Collection<FieldMapping> fieldMappings = new ArrayList<FieldMapping>();

        public Builder key(String name) {
            this.addField(FieldMapping.key(name));
            return this;
        }

        public Builder column(String name, String family, String qualifier) {
            this.addField(FieldMapping.column(name, family, qualifier));
            return this;
        }

        public Builder keyAsColumn(String name, String family) {
            this.addField(FieldMapping.keyAsColumn(name, family));
            return this;
        }

        public Builder keyAsColumn(String name, String family, String qualifierPrefix) {
            this.addField(FieldMapping.keyAsColumn(name, family, qualifierPrefix));
            return this;
        }

        public Builder counter(String name, String family, String qualifier) {
            this.addField(FieldMapping.counter(name, family, qualifier));
            return this;
        }

        public Builder occ(String name) {
            this.addField(FieldMapping.occ(name));
            return this;
        }

        public Builder version(String name) {
            return this.occ(name);
        }

        public Builder fieldMapping(FieldMapping fieldMapping) {
            this.addField(fieldMapping);
            return this;
        }

        public Builder fieldMappings(Collection<FieldMapping> fieldMappings) {
            for (FieldMapping fieldMapping : fieldMappings) {
                this.addField(fieldMapping);
            }
            return this;
        }

        public ColumnMapping build() {
            return new ColumnMapping(this.fieldMappings);
        }

        private void addField(FieldMapping fm) {
            if (fm.getMappingType() == FieldMapping.MappingType.OCC_VERSION) {
                ValidationException.check(!this.hasOCCVersion, "Cannot use multiple occVersion fields", new Object[0]);
                ValidationException.check(!this.hasCounter, "Cannot use both counter and occVersion fields", new Object[0]);
                this.hasOCCVersion = true;
            } else if (fm.getMappingType() == FieldMapping.MappingType.COUNTER) {
                ValidationException.check(!this.hasOCCVersion, "Cannot use both counter and occVersion fields", new Object[0]);
                this.hasCounter = true;
            }
            this.fieldMappings.add(fm);
        }
    }
}

