/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.data.CompressionType;

@Immutable
public class Format {
    private final String name;
    private final CompressionType defaultCompressionType;
    private final Set<CompressionType> supportedCompressionTypes;

    Format(String name, CompressionType defaultCompressionType, CompressionType[] supportedCompressionTypes) {
        this.name = name;
        this.defaultCompressionType = defaultCompressionType;
        this.supportedCompressionTypes = ImmutableSet.copyOf((Object[])supportedCompressionTypes);
    }

    public String getName() {
        return this.name;
    }

    public String getExtension() {
        return this.name;
    }

    public Set<CompressionType> getSupportedCompressionTypes() {
        return this.supportedCompressionTypes;
    }

    public CompressionType getDefaultCompressionType() {
        return this.defaultCompressionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        Format that = (Format)o;
        return Objects.equal((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }
}

