/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import org.kitesdk.data.CompressionType;
import org.kitesdk.data.Format;

public class Formats {
    public static final Format AVRO = new Format("avro", CompressionType.Snappy, new CompressionType[]{CompressionType.Uncompressed, CompressionType.Snappy, CompressionType.Deflate, CompressionType.Bzip2});
    public static final Format PARQUET = new Format("parquet", CompressionType.Snappy, new CompressionType[]{CompressionType.Uncompressed, CompressionType.Snappy, CompressionType.Deflate});
    public static final Format CSV = new Format("csv", CompressionType.Uncompressed, new CompressionType[]{CompressionType.Uncompressed});

    private Formats() {
    }

    public static Format fromString(String formatName) {
        if (formatName.equals("avro")) {
            return AVRO;
        }
        if (formatName.equals("parquet")) {
            return PARQUET;
        }
        if (formatName.equals("csv")) {
            return CSV;
        }
        throw new IllegalArgumentException("Unknown format type: " + formatName);
    }
}

