/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.Conversions;
import org.kitesdk.data.spi.Pair;
import org.kitesdk.data.spi.Registration;
import org.kitesdk.data.spi.URIPattern;

public class URIBuilder {
    public static final String DATASET_NAME_OPTION = "dataset";
    public static final String NAMESPACE_OPTION = "namespace";
    public static final String NAMESPACE_DEFAULT = "default";
    public static final String DATASET_SCHEME = "dataset";
    public static final String VIEW_SCHEME = "view";
    public static final String REPO_SCHEME = "repo";
    private URIPattern pattern;
    private boolean isView = false;
    private Map<String, String> options = Maps.newLinkedHashMap();

    public static URI build(String repoUri, String namespace, String dataset) {
        return URIBuilder.build(URI.create(repoUri), namespace, dataset);
    }

    public static URI build(URI repoUri, String namespace, String dataset) {
        return new URIBuilder(repoUri, namespace, dataset).build();
    }

    public URIBuilder(String repoUri, String namespace, String datasetName) {
        this(URI.create(repoUri), namespace, datasetName);
    }

    public URIBuilder(URI repoUri, String namespace, String dataset) {
        Preconditions.checkNotNull((Object)repoUri, (Object)"Repository URI cannot be null");
        Preconditions.checkNotNull((Object)dataset, (Object)"Dataset name cannot be null");
        Preconditions.checkArgument((boolean)REPO_SCHEME.equals(repoUri.getScheme()));
        Pair<URIPattern, Map<String, String>> pair = Registration.lookupPatternByRepoUri(URI.create(repoUri.getRawSchemeSpecificPart()));
        this.pattern = pair.first();
        this.options.putAll(pair.second());
        this.options.put("dataset", dataset);
        this.options.put(NAMESPACE_OPTION, namespace);
    }

    public URIBuilder(String uri) {
        this(URI.create(uri));
    }

    public URIBuilder(URI uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"URI cannot be null");
        boolean isViewUri = VIEW_SCHEME.equals(uri.getScheme());
        Preconditions.checkArgument((isViewUri || "dataset".equals(uri.getScheme()) ? 1 : 0) != 0, (Object)("Not a dataset or view URI: " + uri));
        Pair<URIPattern, Map<String, String>> pair = Registration.lookupDatasetPattern(URI.create(uri.getRawSchemeSpecificPart()));
        this.pattern = pair.first();
        this.isView = isViewUri;
        this.options.put(NAMESPACE_OPTION, NAMESPACE_DEFAULT);
        this.options.putAll(pair.second());
    }

    @VisibleForTesting
    URIBuilder constraints(Constraints constraints) {
        this.options.putAll(constraints.toQueryMap());
        this.isView = !constraints.isUnbounded();
        return this;
    }

    public URIBuilder with(String name, Object value) {
        this.options.put(name, Conversions.makeString(value));
        this.isView = true;
        return this;
    }

    public URIBuilder namespace(String namespace) {
        this.options.put(NAMESPACE_OPTION, namespace);
        return this;
    }

    public URIBuilder dataset(String dataset) {
        this.options.put("dataset", dataset);
        return this;
    }

    public URI build() {
        try {
            return new URI((this.isView ? VIEW_SCHEME : "dataset") + ":" + this.pattern.construct(this.options).toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not build URI", e);
        }
    }
}

