/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import com.google.common.base.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.avro.Schema;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.RefinableView;
import org.kitesdk.data.spi.AbstractRefinableView;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.DataModelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public abstract class AbstractDataset<E>
implements Dataset<E>,
RefinableView<E> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDataset.class);
    protected final Class<E> type;

    protected abstract RefinableView<E> asRefinableView();

    public AbstractDataset(Class<E> type, Schema schema) {
        this.type = DataModelUtil.resolveType(type, schema);
    }

    @Override
    public Dataset<E> getDataset() {
        return this;
    }

    public abstract AbstractRefinableView<E> filter(Constraints var1);

    @Override
    public DatasetWriter<E> newWriter() {
        LOG.debug("Getting writer to dataset:{}", (Object)this);
        return this.asRefinableView().newWriter();
    }

    @Override
    public DatasetReader<E> newReader() {
        LOG.debug("Getting reader for dataset:{}", (Object)this);
        return this.asRefinableView().newReader();
    }

    @Override
    public boolean includes(E entity) {
        return true;
    }

    @Override
    public Class<E> getType() {
        return this.type;
    }

    @Override
    public RefinableView<E> with(String name, Object ... values) {
        return this.asRefinableView().with(name, values);
    }

    @Override
    public RefinableView<E> from(String name, Comparable value) {
        return this.asRefinableView().from(name, value);
    }

    @Override
    public RefinableView<E> fromAfter(String name, Comparable value) {
        return this.asRefinableView().fromAfter(name, value);
    }

    @Override
    public RefinableView<E> to(String name, Comparable value) {
        return this.asRefinableView().to(name, value);
    }

    @Override
    public RefinableView<E> toBefore(String name, Comparable value) {
        return this.asRefinableView().toBefore(name, value);
    }

    @Override
    public boolean deleteAll() {
        throw new UnsupportedOperationException("This Dataset does not support bulk deletion");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !Objects.equal(this.getClass(), obj.getClass())) {
            return false;
        }
        AbstractDataset other = (AbstractDataset)obj;
        return Objects.equal((Object)this.getName(), (Object)other.getName()) && Objects.equal((Object)this.getDescriptor(), (Object)other.getDescriptor()) && Objects.equal(this.getType(), other.getType());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getClass(), this.getName(), this.getDescriptor(), this.type});
    }
}

