/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avro.Schema;
import org.kitesdk.data.ColumnMapping;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.FieldMapping;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.spi.JsonUtil;

public class ColumnMappingParser {
    private static final String MAPPING = "mapping";
    private static final String TYPE = "type";
    private static final String SOURCE = "source";
    private static final String FAMILY = "family";
    private static final String QUALIFIER = "qualifier";
    private static final String PREFIX = "prefix";
    private static final String VALUE = "value";
    private static final Splitter VALUE_SPLITTER = Splitter.on((String)":").limit(2);

    public static ColumnMapping parse(String mappingDescriptor) {
        return ColumnMappingParser.buildColumnMapping(JsonUtil.parse(mappingDescriptor));
    }

    public static ColumnMapping parse(File file) {
        return ColumnMappingParser.buildColumnMapping(JsonUtil.parse(file));
    }

    public static ColumnMapping parse(InputStream in) {
        return ColumnMappingParser.buildColumnMapping(JsonUtil.parse(in));
    }

    public static boolean hasEmbeddedColumnMapping(Schema schema) {
        return schema.getJsonProp(MAPPING) != null;
    }

    public static Schema removeEmbeddedMapping(Schema schema) {
        ObjectNode schemaJson = JsonUtil.parse(schema.toString(), ObjectNode.class);
        schemaJson.remove(MAPPING);
        return new Schema.Parser().parse(schemaJson.toString());
    }

    public static ColumnMapping parseFromSchema(Schema schema) {
        return ColumnMappingParser.parse(schema.getJsonProp(MAPPING).toString());
    }

    public static boolean hasEmbeddedFieldMappings(Schema schema) {
        if (Schema.Type.RECORD == schema.getType()) {
            for (Schema.Field field : schema.getFields()) {
                if (field.getJsonProp(MAPPING) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static ColumnMapping parseFromSchemaFields(Schema schema) {
        if (Schema.Type.RECORD == schema.getType()) {
            ColumnMapping.Builder builder = new ColumnMapping.Builder();
            for (Schema.Field field : schema.getFields()) {
                if (field.getJsonProp(MAPPING) == null) continue;
                builder.fieldMapping(ColumnMappingParser.parseFieldMapping(field.name(), JsonUtil.parse(field.getJsonProp(MAPPING).toString())));
            }
            return builder.build();
        }
        throw new IllegalArgumentException("Cannot parse field-level mappings from non-Record");
    }

    public static Schema embedColumnMapping(Schema schema, ColumnMapping mapping) {
        ObjectNode schemaJson = JsonUtil.parse(schema.toString(), ObjectNode.class);
        schemaJson.set(MAPPING, ColumnMappingParser.toJson(mapping));
        return new Schema.Parser().parse(schemaJson.toString());
    }

    public static Map<Integer, FieldMapping> parseKeyMappingsFromSchemaFields(Schema schema) {
        HashMap keyMappings = Maps.newHashMap();
        if (Schema.Type.RECORD == schema.getType()) {
            for (Schema.Field field : schema.getFields()) {
                if (field.getJsonProp(MAPPING) == null) continue;
                JsonNode mappingNode = JsonUtil.parse(field.getJsonProp(MAPPING).toString());
                FieldMapping fm = ColumnMappingParser.parseFieldMapping(field.name(), mappingNode);
                if (FieldMapping.MappingType.KEY != fm.getMappingType() || !mappingNode.has(VALUE)) continue;
                Integer index = mappingNode.get(VALUE).asInt();
                keyMappings.put(index, fm);
            }
            return keyMappings;
        }
        throw new IllegalArgumentException("Cannot parse field-level mappings from non-Record");
    }

    public static FieldMapping parseFieldMapping(JsonNode mappingNode) {
        ValidationException.check(mappingNode.isObject(), "A column mapping must be a JSON record", new Object[0]);
        ValidationException.check(mappingNode.has(SOURCE), "Partitioners must have a %s.", SOURCE);
        String source = mappingNode.get(SOURCE).asText();
        return ColumnMappingParser.parseFieldMapping(source, mappingNode);
    }

    public static FieldMapping parseFieldMapping(String source, JsonNode mappingNode) {
        ValidationException.check(mappingNode.isObject(), "A column mapping must be a JSON record", new Object[0]);
        ValidationException.check(mappingNode.has(TYPE), "Column mappings must have a %s.", TYPE);
        String type = mappingNode.get(TYPE).asText();
        if ("occVersion".equals(type)) {
            return FieldMapping.version(source);
        }
        if ("key".equals(type)) {
            return FieldMapping.key(source);
        }
        String family = null;
        String qualifier = null;
        String prefix = null;
        if (mappingNode.has(VALUE)) {
            String value = mappingNode.get(VALUE).asText();
            Iterator values = VALUE_SPLITTER.split((CharSequence)value).iterator();
            if (values.hasNext()) {
                family = (String)values.next();
            }
            if (values.hasNext()) {
                if ("keyAsColumn".equals(type)) {
                    prefix = (String)values.next();
                    if (prefix.isEmpty()) {
                        prefix = null;
                    }
                } else {
                    qualifier = (String)values.next();
                }
            }
        }
        if (mappingNode.has(FAMILY)) {
            family = mappingNode.get(FAMILY).textValue();
        }
        if (mappingNode.has(QUALIFIER)) {
            qualifier = mappingNode.get(QUALIFIER).textValue();
        }
        if ("column".equals(type)) {
            ValidationException.check(family != null && !family.isEmpty(), "Column mapping %s must have a %s", source, FAMILY);
            ValidationException.check(qualifier != null && !qualifier.isEmpty(), "Column mapping %s must have a %s", source, QUALIFIER);
            return FieldMapping.column(source, family, qualifier);
        }
        if ("keyAsColumn".equals(type)) {
            ValidationException.check(family != null && !family.isEmpty(), "Column mapping %s must have a %s", source, FAMILY);
            ValidationException.check(qualifier == null, "Key-as-column mapping %s cannot have a %s", source, QUALIFIER);
            if (mappingNode.has(PREFIX) && (prefix = mappingNode.get(PREFIX).asText()).isEmpty()) {
                prefix = null;
            }
            return FieldMapping.keyAsColumn(source, family, prefix);
        }
        if ("counter".equals(type)) {
            ValidationException.check(family != null && !family.isEmpty(), "Counter mapping %s must have a %s", source, FAMILY);
            ValidationException.check(qualifier != null && !qualifier.isEmpty(), "Counter mapping %s must have a %s", source, QUALIFIER);
            return FieldMapping.counter(source, family, qualifier);
        }
        throw new ValidationException("Invalid mapping type: " + type);
    }

    private static ColumnMapping buildColumnMapping(JsonNode node) {
        ValidationException.check(node.isArray(), "Must be a JSON array of column mappings", new Object[0]);
        ColumnMapping.Builder builder = new ColumnMapping.Builder();
        Iterator it = node.elements();
        while (it.hasNext()) {
            builder.fieldMapping(ColumnMappingParser.parseFieldMapping((JsonNode)it.next()));
        }
        return builder.build();
    }

    private static JsonNode toJson(FieldMapping fm) {
        ObjectNode fieldMapping = JsonNodeFactory.instance.objectNode();
        fieldMapping.set(SOURCE, (JsonNode)TextNode.valueOf((String)fm.getFieldName()));
        switch (fm.getMappingType()) {
            case KEY: {
                fieldMapping.set(TYPE, (JsonNode)TextNode.valueOf((String)"key"));
                break;
            }
            case KEY_AS_COLUMN: {
                fieldMapping.set(TYPE, (JsonNode)TextNode.valueOf((String)"keyAsColumn"));
                fieldMapping.set(FAMILY, (JsonNode)TextNode.valueOf((String)fm.getFamilyAsString()));
                if (fm.getPrefix() == null) break;
                fieldMapping.set(PREFIX, (JsonNode)TextNode.valueOf((String)fm.getPrefix()));
                break;
            }
            case COLUMN: {
                fieldMapping.set(TYPE, (JsonNode)TextNode.valueOf((String)"column"));
                fieldMapping.set(FAMILY, (JsonNode)TextNode.valueOf((String)fm.getFamilyAsString()));
                fieldMapping.set(QUALIFIER, (JsonNode)TextNode.valueOf((String)fm.getQualifierAsString()));
                break;
            }
            case COUNTER: {
                fieldMapping.set(TYPE, (JsonNode)TextNode.valueOf((String)"counter"));
                fieldMapping.set(FAMILY, (JsonNode)TextNode.valueOf((String)fm.getFamilyAsString()));
                fieldMapping.set(QUALIFIER, (JsonNode)TextNode.valueOf((String)fm.getQualifierAsString()));
                break;
            }
            case OCC_VERSION: {
                fieldMapping.set(TYPE, (JsonNode)TextNode.valueOf((String)"occVersion"));
                break;
            }
            default: {
                throw new ValidationException("Unknown mapping type: " + (Object)((Object)fm.getMappingType()));
            }
        }
        return fieldMapping;
    }

    public static String toString(FieldMapping mapping) {
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator gen = new JsonFactory().createGenerator((Writer)writer);
            gen.setCodec((ObjectCodec)new ObjectMapper());
            gen.writeTree((TreeNode)ColumnMappingParser.toJson(mapping));
            gen.close();
        }
        catch (IOException e) {
            throw new DatasetIOException("Cannot write to JSON generator", e);
        }
        return writer.toString();
    }

    private static JsonNode toJson(ColumnMapping mapping) {
        ArrayNode mappingJson = JsonNodeFactory.instance.arrayNode();
        for (FieldMapping fm : mapping.getFieldMappings()) {
            mappingJson.add(ColumnMappingParser.toJson(fm));
        }
        return mappingJson;
    }

    public static String toString(ColumnMapping mapping, boolean pretty) {
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator gen = new JsonFactory().createGenerator((Writer)writer);
            if (pretty) {
                gen.useDefaultPrettyPrinter();
            }
            gen.setCodec((ObjectCodec)new ObjectMapper());
            gen.writeTree((TreeNode)ColumnMappingParser.toJson(mapping));
            gen.close();
        }
        catch (IOException e) {
            throw new DatasetIOException("Cannot write to JSON generator", e);
        }
        return writer.toString();
    }
}

