/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.IncompatibleSchemaException;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.SchemaUtil;
import org.kitesdk.data.spi.SchemaValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Compatibility {
    private static final Logger LOG = LoggerFactory.getLogger(Compatibility.class);
    private static Pattern hiveCompatible = Pattern.compile("[a-zA-Z0-9_]+");
    private static Pattern avroCompatible = Pattern.compile("^[A-Za-z_][A-Za-z\\d_]*$");

    public static void checkAndWarn(String namespace, String name, DatasetDescriptor descriptor) {
        try {
            Compatibility.checkDatasetName(namespace, name);
            Compatibility.checkDescriptor(descriptor);
        }
        catch (IllegalArgumentException e) {
            LOG.warn(e.getMessage());
        }
        catch (IllegalStateException e) {
            LOG.warn(e.getMessage());
        }
    }

    public static void checkAndWarn(String namespace, String datasetName, Schema schema) {
        try {
            Compatibility.checkDatasetName(namespace, datasetName);
            Compatibility.checkSchema(schema);
        }
        catch (IllegalArgumentException e) {
            LOG.warn(e.getMessage());
        }
        catch (IllegalStateException e) {
            LOG.warn(e.getMessage());
        }
    }

    public static void checkDatasetName(String namespace, String name) {
        Preconditions.checkNotNull((Object)namespace, (Object)"Namespace cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Dataset name cannot be null");
        Preconditions.checkArgument((boolean)Compatibility.isCompatibleName(namespace), (String)"Deprecated: Namespace %s is not alphanumeric (plus '_')", (Object[])new Object[]{namespace});
        Preconditions.checkArgument((boolean)Compatibility.isCompatibleName(name), (String)"Deprecated: Dataset name %s is not alphanumeric (plus '_')", (Object[])new Object[]{name});
    }

    public static void checkSchema(Schema schema) {
        Preconditions.checkNotNull((Object)schema, (Object)"Schema cannot be null");
        List<String> incompatible = Compatibility.getIncompatibleNames(schema);
        Preconditions.checkState((boolean)incompatible.isEmpty(), (String)"Deprecated: field names are not alphanumeric (plus '_'): %s", (Object[])new Object[]{Joiner.on((String)", ").join(incompatible)});
    }

    public static void checkDescriptor(DatasetDescriptor descriptor) {
        Preconditions.checkNotNull((Object)descriptor, (Object)"Descriptor cannot be null");
        Schema schema = descriptor.getSchema();
        Compatibility.checkSchema(schema);
        if (descriptor.isPartitioned()) {
            Preconditions.checkArgument((schema.getType() == Schema.Type.RECORD ? 1 : 0) != 0, (Object)"[BUG] Partitioned datasets must have record schemas");
            HashSet names = Sets.newHashSet();
            for (Schema.Field field : schema.getFields()) {
                names.add(field.name());
            }
            ArrayList incompatible = Lists.newArrayList();
            ArrayList duplicates = Lists.newArrayList();
            for (FieldPartitioner fp : descriptor.getPartitionStrategy().getFieldPartitioners()) {
                String name = fp.getName();
                if (!Compatibility.isCompatibleName(name)) {
                    incompatible.add(name);
                    continue;
                }
                if (names.contains(name)) {
                    duplicates.add(name);
                    continue;
                }
                names.add(name);
            }
            Preconditions.checkState((boolean)incompatible.isEmpty(), (String)"Deprecated: partition names are not alphanumeric (plus '_'): %s", (Object[])new Object[]{Joiner.on((String)", ").join((Iterable)incompatible)});
            Preconditions.checkState((boolean)duplicates.isEmpty(), (String)"Deprecated: partition names duplicate data fields: %s", (Object[])new Object[]{Joiner.on((String)", ").join((Iterable)duplicates)});
        }
    }

    public static boolean isCompatibleName(String name) {
        return hiveCompatible.matcher(name).matches();
    }

    private static List<String> getIncompatibleNames(Schema schema) {
        NameValidation validation = new NameValidation();
        SchemaUtil.visit(schema, validation);
        return validation.getIncompatibleNames();
    }

    public static boolean isAvroCompatibleName(String name) {
        return avroCompatible.matcher(name).matches();
    }

    public static void checkUpdate(DatasetDescriptor existing, DatasetDescriptor updated) {
        Compatibility.checkNotChanged("location", existing.getLocation(), updated.getLocation());
        Compatibility.checkCompatible(existing, updated);
    }

    public static void checkCompatible(DatasetDescriptor existing, DatasetDescriptor test) {
        Schema testSchema;
        Schema oldSchema;
        Compatibility.checkNotChanged("format", existing.getFormat(), test.getFormat());
        Compatibility.checkNotChanged("partitioning", existing.isPartitioned(), test.isPartitioned());
        if (existing.isPartitioned()) {
            Compatibility.checkNotChanged("partition strategy", existing.getPartitionStrategy(), test.getPartitionStrategy());
        }
        if (!SchemaValidationUtil.canRead(oldSchema = existing.getSchema(), testSchema = test.getSchema())) {
            throw new IncompatibleSchemaException("Schema cannot read data written using existing schema. Schema: " + testSchema.toString(true) + "\nExisting schema: " + oldSchema.toString(true));
        }
    }

    private static void checkNotChanged(String what, @Nullable Object existing, @Nullable Object test) {
        ValidationException.check(existing == test || existing != null && existing.equals(test), "Dataset %s is not compatible with existing: %s != %s", what, String.valueOf(existing), String.valueOf(test));
    }

    private static class NameValidation
    extends SchemaUtil.SchemaVisitor<Void> {
        private List<String> incompatible = Lists.newArrayList();

        private NameValidation() {
        }

        @Override
        public Void record(Schema record, List<String> names, List<Void> fields) {
            String recordName = record.getName();
            for (String name : names) {
                if (Compatibility.isCompatibleName(name)) continue;
                this.incompatible.add(recordName + "." + name);
            }
            return null;
        }

        public List<String> getIncompatibleNames() {
            return this.incompatible;
        }
    }
}

