/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.avro.Schema;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.spi.EntityAccessor;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.KeyRangeIterable;
import org.kitesdk.data.spi.Marker;
import org.kitesdk.data.spi.MarkerRange;
import org.kitesdk.data.spi.SchemaUtil;
import org.kitesdk.data.spi.StorageKey;
import org.kitesdk.data.spi.TimeDomain;
import org.kitesdk.data.spi.partition.CalendarFieldPartitioner;
import org.kitesdk.data.spi.partition.ProvidedFieldPartitioner;
import org.kitesdk.data.spi.predicates.Exists;
import org.kitesdk.data.spi.predicates.In;
import org.kitesdk.data.spi.predicates.Predicates;
import org.kitesdk.data.spi.predicates.Range;
import org.kitesdk.data.spi.predicates.Ranges;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class Constraints {
    private static final Logger LOG = LoggerFactory.getLogger(Constraints.class);
    private final Schema schema;
    private final PartitionStrategy strategy;
    private final Map<String, Predicate> constraints;
    private final Map<String, Object> provided;

    public Constraints(Schema schema) {
        this(schema, null);
    }

    public Constraints(Schema schema, PartitionStrategy strategy) {
        this.schema = schema;
        this.strategy = strategy;
        this.constraints = ImmutableMap.of();
        this.provided = ImmutableMap.of();
    }

    private Constraints(Schema schema, PartitionStrategy strategy, Map<String, Predicate> constraints, Map<String, Object> provided) {
        this.schema = schema;
        this.strategy = strategy;
        this.constraints = constraints;
        this.provided = provided;
    }

    private Constraints(Constraints copy, String name, Predicate predicate) {
        this.schema = copy.schema;
        this.strategy = copy.strategy;
        this.constraints = Constraints.updateImmutable(copy.constraints, name, predicate);
        this.provided = copy.provided;
    }

    private Constraints(Constraints copy, String name, Predicate predicate, Object value) {
        this.schema = copy.schema;
        this.strategy = copy.strategy;
        this.constraints = Constraints.updateImmutable(copy.constraints, name, predicate);
        this.provided = Constraints.updateImmutable(copy.provided, name, value);
    }

    @VisibleForTesting
    Constraints partitionedBy(PartitionStrategy strategy) {
        return new Constraints(this.schema, strategy, this.constraints, this.provided);
    }

    public <E> Predicate<E> toEntityPredicate(EntityAccessor<E> accessor) {
        return Constraints.entityPredicate(this.constraints, this.schema, accessor, this.strategy);
    }

    public <E> Predicate<E> toEntityPredicate(StorageKey key, EntityAccessor<E> accessor) {
        if (key != null) {
            Map<String, Predicate> predicates = this.minimizeFor(key);
            if (predicates.isEmpty()) {
                return com.google.common.base.Predicates.alwaysTrue();
            }
            return Constraints.entityPredicate(predicates, this.schema, accessor, this.strategy);
        }
        return this.toEntityPredicate(accessor);
    }

    @VisibleForTesting
    Map<String, Predicate> minimizeFor(StorageKey key) {
        HashMap unsatisfied = Maps.newHashMap(this.constraints);
        PartitionStrategy strategy = key.getPartitionStrategy();
        HashSet timeFields = Sets.newHashSet();
        int i = 0;
        for (FieldPartitioner fp : strategy.getFieldPartitioners()) {
            Predicate original;
            String partition = fp.getName();
            Predicate partitionPredicate = (Predicate)unsatisfied.get(partition);
            if (partitionPredicate != null && partitionPredicate.apply(key.get(i))) {
                unsatisfied.remove(partition);
                LOG.debug("removing " + partition + " satisfied by " + key.get(i));
            }
            String source = fp.getSourceName();
            if (fp instanceof CalendarFieldPartitioner) {
                timeFields.add(source);
            }
            if ((original = (Predicate)unsatisfied.get(source)) != null) {
                Predicate isSatisfiedBy = fp.projectStrict(original);
                LOG.debug("original: " + original + ", strict: " + isSatisfiedBy);
                if (isSatisfiedBy != null && isSatisfiedBy.apply(key.get(i))) {
                    LOG.debug("removing " + source + " satisfied by " + key.get(i));
                    unsatisfied.remove(source);
                }
            }
            ++i;
        }
        for (String timeField : timeFields) {
            Predicate original = (Predicate)unsatisfied.get(timeField);
            if (original == null) continue;
            Predicate<Marker> isSatisfiedBy = TimeDomain.get(strategy, timeField).projectStrict((Predicate<Long>)original);
            LOG.debug("original: " + original + ", strict: " + isSatisfiedBy);
            if (isSatisfiedBy == null || !isSatisfiedBy.apply((Object)key)) continue;
            LOG.debug("removing " + timeField + " satisfied by " + key);
            unsatisfied.remove(timeField);
        }
        return ImmutableMap.copyOf((Map)unsatisfied);
    }

    public Predicate<StorageKey> toKeyPredicate() {
        Preconditions.checkNotNull((Object)this.strategy, (Object)"Cannot produce a key predicate without a partition strategy");
        return new KeyPredicate(this.constraints, this.strategy);
    }

    public Iterable<MarkerRange> toKeyRanges() {
        Preconditions.checkNotNull((Object)this.strategy, (Object)"Cannot produce key ranges without a partition strategy");
        return new KeyRangeIterable(this.strategy, this.constraints);
    }

    public boolean alignedWithBoundaries() {
        Preconditions.checkNotNull((Object)this.strategy, (Object)"Cannot produce key ranges without a partition strategy");
        HashMultimap partitioners = HashMultimap.create();
        HashSet partitionFields = Sets.newHashSet();
        for (FieldPartitioner fieldPartitioner : this.strategy.getFieldPartitioners()) {
            partitioners.put((Object)fieldPartitioner.getSourceName(), (Object)fieldPartitioner);
            partitionFields.add(fieldPartitioner.getName());
        }
        for (Map.Entry entry : this.constraints.entrySet()) {
            if (partitionFields.contains(entry.getKey())) continue;
            Collection fps = partitioners.get(entry.getKey());
            if (fps.isEmpty()) {
                LOG.debug("No field partitioners for key {}", entry.getKey());
                return false;
            }
            Predicate predicate = (Predicate)entry.getValue();
            if (predicate instanceof Exists) continue;
            boolean satisfied = false;
            for (FieldPartitioner fp : fps) {
                if (fp instanceof CalendarFieldPartitioner) {
                    TimeDomain domain = TimeDomain.get(this.strategy, (String)entry.getKey());
                    Predicate<Marker> strict = domain.projectStrict((Predicate<Long>)predicate);
                    Predicate<Marker> permissive = domain.project((Predicate<Long>)predicate);
                    LOG.debug("Time predicate strict: {}", strict);
                    LOG.debug("Time predicate permissive: {}", permissive);
                    satisfied = strict != null && strict.equals(permissive);
                    break;
                }
                Predicate strict = fp.projectStrict(predicate);
                Predicate permissive = fp.project(predicate);
                if (strict == null || !strict.equals(permissive)) continue;
                satisfied = true;
                break;
            }
            if (satisfied) continue;
            LOG.debug("Predicate not satisfied: {}", (Object)predicate);
            return false;
        }
        return true;
    }

    public Map<String, Object> getProvidedValues() {
        return this.provided;
    }

    public Constraints with(String name, Object ... values) {
        SchemaUtil.checkTypeConsistency(this.schema, this.strategy, name, values);
        if (values.length > 0) {
            this.checkContained(name, values);
            In<Object> added = Predicates.in(values);
            if (values.length == 1) {
                return new Constraints(this, name, added, values[0]);
            }
            return new Constraints(this, name, added);
        }
        if (!this.constraints.containsKey(name)) {
            return new Constraints(this, name, Predicates.exists());
        }
        return this;
    }

    public Constraints from(String name, Comparable value) {
        SchemaUtil.checkTypeConsistency(this.schema, this.strategy, name, value);
        this.checkContained(name, value);
        Range<Comparable> added = Ranges.atLeast(value);
        return new Constraints(this, name, Constraints.combine(this.constraints.get(name), added));
    }

    public Constraints fromAfter(String name, Comparable value) {
        SchemaUtil.checkTypeConsistency(this.schema, this.strategy, name, value);
        this.checkContained(name, value);
        Range<Comparable> added = Ranges.greaterThan(value);
        return new Constraints(this, name, Constraints.combine(this.constraints.get(name), added));
    }

    public Constraints to(String name, Comparable value) {
        SchemaUtil.checkTypeConsistency(this.schema, this.strategy, name, value);
        this.checkContained(name, value);
        Range<Comparable> added = Ranges.atMost(value);
        return new Constraints(this, name, Constraints.combine(this.constraints.get(name), added));
    }

    public Constraints toBefore(String name, Comparable value) {
        SchemaUtil.checkTypeConsistency(this.schema, this.strategy, name, value);
        this.checkContained(name, value);
        Range<Comparable> added = Ranges.lessThan(value);
        return new Constraints(this, name, Constraints.combine(this.constraints.get(name), added));
    }

    @VisibleForTesting
    Predicate get(String name) {
        return this.constraints.get(name);
    }

    private void checkContained(String name, Object ... values) {
        for (Object value : values) {
            if (!this.constraints.containsKey(name)) continue;
            Predicate current = this.constraints.get(name);
            Preconditions.checkArgument((boolean)current.apply(value), (String)"%s does not match %s", (Object[])new Object[]{current, value});
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Constraints that = (Constraints)o;
        return Objects.equal(this.constraints, that.constraints) && Objects.equal((Object)this.schema, (Object)that.schema);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.schema, this.constraints});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).addValue(this.constraints).toString();
    }

    public Map<String, String> toQueryMap() {
        LinkedHashMap query = Maps.newLinkedHashMap();
        for (Map.Entry<String, Predicate> entry : this.constraints.entrySet()) {
            String name = entry.getKey();
            Schema fieldSchema = SchemaUtil.fieldSchema(this.schema, this.strategy, name);
            query.put(name, Predicates.toString(entry.getValue(), fieldSchema));
        }
        return query;
    }

    public static Constraints fromQueryMap(Schema schema, PartitionStrategy strategy, Map<String, String> query) {
        LinkedHashMap constraints = Maps.newLinkedHashMap();
        HashMap provided = Maps.newHashMap();
        for (Map.Entry<String, String> entry : query.entrySet()) {
            Set values;
            String name = entry.getKey();
            if (!SchemaUtil.isField(schema, strategy, name)) continue;
            Schema fieldSchema = SchemaUtil.fieldSchema(schema, strategy, name);
            Predicate predicate = Predicates.fromString(entry.getValue(), fieldSchema);
            constraints.put(name, predicate);
            if (!(predicate instanceof In) || (values = Predicates.asSet((In)predicate)).size() != 1) continue;
            provided.put(name, Iterables.getOnlyElement(values));
        }
        return new Constraints(schema, strategy, constraints, provided);
    }

    static Predicate combine(Predicate left, Predicate right) {
        if (left == right) {
            return left;
        }
        if (left == null) {
            return right;
        }
        if (right == null || right instanceof Exists) {
            return left;
        }
        if (left instanceof Exists) {
            return right;
        }
        if (left instanceof In) {
            return ((In)left).filter(right);
        }
        if (right instanceof In) {
            return ((In)right).filter(left);
        }
        if (left instanceof Range && right instanceof Range) {
            return ((Range)left).intersection((Range)right);
        }
        return com.google.common.base.Predicates.and((Predicate)left, (Predicate)right);
    }

    private static <E> Predicate<E> entityPredicate(Map<String, Predicate> predicates, Schema schema, EntityAccessor<E> accessor, PartitionStrategy strategy) {
        if (Schema.Type.RECORD != schema.getType()) {
            return com.google.common.base.Predicates.alwaysTrue();
        }
        return new EntityPredicate<E>(predicates, schema, accessor, strategy);
    }

    private static <K, V> Map<K, V> updateImmutable(Map<K, V> existing, K key, V value) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        boolean added = false;
        for (Map.Entry<K, V> entry : existing.entrySet()) {
            if (key.equals(entry.getKey())) {
                builder.put(key, value);
                added = true;
                continue;
            }
            builder.put(entry.getKey(), entry.getValue());
        }
        if (!added) {
            builder.put(key, value);
        }
        return builder.build();
    }

    public boolean isUnbounded() {
        return this.constraints.isEmpty();
    }

    private static class TransformPredicate<S, T>
    implements Predicate<S> {
        private final Function<S, T> function;
        private final Predicate<T> predicate;

        public TransformPredicate(Function<S, T> function, Predicate<T> predicate) {
            this.function = function;
            this.predicate = predicate;
        }

        public boolean apply(@Nullable S input) {
            return this.predicate.apply(this.function.apply(input));
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("function", this.function).add("predicate", this.predicate).toString();
        }
    }

    private static class KeyPredicate
    implements Predicate<StorageKey> {
        private final List<Predicate> partitionPredicates;
        private final List<Predicate<Marker>> timePredicates;

        private KeyPredicate(Map<String, Predicate> predicates, PartitionStrategy strategy) {
            Preconditions.checkNotNull((Object)strategy, (Object)"Cannot produce KeyPredicate without a PartitionStrategy");
            List<FieldPartitioner> partitioners = strategy.getFieldPartitioners();
            Object[] preds = new Predicate[partitioners.size()];
            HashMap timeFields = Maps.newHashMap();
            for (int i = 0; i < preds.length; ++i) {
                FieldPartitioner fp = partitioners.get(i);
                Predicate sourcePredicate = predicates.get(fp.getSourceName());
                if (sourcePredicate != null) {
                    Predicate projectedPredicate = fp.project(sourcePredicate);
                    if (projectedPredicate != null) {
                        preds[i] = projectedPredicate;
                    }
                    if (fp instanceof CalendarFieldPartitioner) {
                        timeFields.put(fp.getSourceName(), sourcePredicate);
                    }
                }
                Predicate partitionPredicate = predicates.get(fp.getName());
                if (preds[i] != null) {
                    if (partitionPredicate == null) continue;
                    preds[i] = Constraints.combine(partitionPredicate, (Predicate)preds[i]);
                    continue;
                }
                preds[i] = partitionPredicate != null ? partitionPredicate : com.google.common.base.Predicates.alwaysTrue();
            }
            this.partitionPredicates = ImmutableList.copyOf((Object[])preds);
            ArrayList timePreds = Lists.newArrayList();
            for (Map.Entry entry : timeFields.entrySet()) {
                timePreds.add(TimeDomain.get(strategy, (String)entry.getKey()).project((Predicate<Long>)((Predicate)entry.getValue())));
            }
            this.timePredicates = ImmutableList.copyOf((Collection)timePreds);
        }

        public boolean apply(StorageKey key) {
            if (key == null) {
                return false;
            }
            for (int i = 0; i < this.partitionPredicates.size(); ++i) {
                Object pValue = key.get(i);
                if (this.partitionPredicates.get(i).apply(pValue)) continue;
                return false;
            }
            for (Predicate<Marker> timePredicate : this.timePredicates) {
                if (timePredicate.apply((Object)key)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("predicates", this.partitionPredicates).add("timePredicates", this.timePredicates).toString();
        }
    }

    private static class EntityPredicate<E>
    implements Predicate<E> {
        private final List<Map.Entry<Schema.Field, Predicate>> predicatesByField;
        private final EntityAccessor<E> accessor;

        public EntityPredicate(Map<String, Predicate> predicates, Schema schema, EntityAccessor<E> accessor, PartitionStrategy strategy) {
            List fields = schema.getFields();
            this.accessor = accessor;
            HashMap predicateMap = Maps.newHashMap();
            for (Schema.Field field : fields) {
                Predicate sourcePredicate = predicates.get(field.name());
                if (sourcePredicate == null) continue;
                predicateMap.put(field, sourcePredicate);
            }
            if (strategy != null) {
                for (FieldPartitioner fp : strategy.getFieldPartitioners()) {
                    Predicate partitionPredicate;
                    if (fp instanceof ProvidedFieldPartitioner || (partitionPredicate = predicates.get(fp.getName())) == null) continue;
                    TransformPredicate transformPredicate = new TransformPredicate(fp, partitionPredicate);
                    Schema.Field field = schema.getField(fp.getSourceName());
                    Predicate sourcePredicate = (Predicate)predicateMap.get(field);
                    if (sourcePredicate != null) {
                        predicateMap.put(field, Constraints.combine(sourcePredicate, transformPredicate));
                        continue;
                    }
                    predicateMap.put(field, transformPredicate);
                }
            }
            this.predicatesByField = ImmutableList.copyOf(predicateMap.entrySet());
        }

        public boolean apply(@Nullable E entity) {
            if (entity == null) {
                return false;
            }
            for (Map.Entry<Schema.Field, Predicate> entry : this.predicatesByField) {
                Object eValue = this.accessor.get(entity, (Iterable<Schema.Field>)ImmutableList.of((Object)entry.getKey()));
                if (entry.getValue().apply(eValue)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EntityPredicate other = (EntityPredicate)obj;
            return Objects.equal(this.predicatesByField, other.predicatesByField);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.predicatesByField});
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("predicates", this.predicatesByField).toString();
        }
    }
}

