/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.spi.DataModelUtil;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.SchemaUtil;
import org.kitesdk.data.spi.StorageKey;
import org.kitesdk.data.spi.partition.ProvidedFieldPartitioner;

@Immutable
public class EntityAccessor<E> {
    private final Schema schema;
    private final Class<E> type;
    private final GenericData model;
    private final Map<String, List<Schema.Field>> cache = Maps.newHashMap();

    EntityAccessor(Class<E> type, Schema schema) {
        this.type = DataModelUtil.resolveType(type, schema);
        this.schema = DataModelUtil.getReaderSchema(this.type, schema);
        this.model = DataModelUtil.getDataModelForType(this.type);
    }

    public Class<E> getType() {
        return this.type;
    }

    public Schema getEntitySchema() {
        return this.schema;
    }

    public Object get(E object, String name) {
        Object value;
        ArrayList fields = this.cache.get(name);
        if (fields != null) {
            value = this.get(object, fields);
        } else {
            value = object;
            fields = Lists.newArrayList();
            Schema nested = this.schema;
            for (String level : SchemaUtil.NAME_SPLITTER.split((CharSequence)name)) {
                if (nested.getType() == Schema.Type.UNION) {
                    List types = nested.getTypes();
                    nested = ((Schema)types.get(0)).getType() == Schema.Type.NULL ? (Schema)types.get(1) : (Schema)types.get(0);
                }
                Schema.Field field = nested.getField(level);
                fields.add(field);
                nested = field.schema();
                value = this.model.getField(value, level, field.pos());
            }
            this.cache.put(name, fields);
        }
        return value;
    }

    public Object get(E object, Iterable<Schema.Field> fields) {
        Object value = object;
        for (Schema.Field level : fields) {
            value = this.model.getField(value, level.name(), level.pos());
        }
        return value;
    }

    public StorageKey keyFor(E object, @Nullable Map<String, Object> provided, StorageKey reuse) {
        Preconditions.checkNotNull((Object)reuse, (Object)"Cannot use null key");
        PartitionStrategy strategy = reuse.getPartitionStrategy();
        List<FieldPartitioner> partitioners = strategy.getFieldPartitioners();
        int n = partitioners.size();
        for (int i = 0; i < n; ++i) {
            reuse.replace(i, this.partitionValue(object, provided, partitioners.get(i)));
        }
        return reuse;
    }

    @VisibleForTesting
    StorageKey keyFor(E object, StorageKey reuse) {
        return this.keyFor(object, null, reuse);
    }

    private Object partitionValue(E object, @Nullable Map<String, Object> provided, FieldPartitioner fp) {
        if (fp instanceof ProvidedFieldPartitioner) {
            String name = fp.getName();
            Preconditions.checkArgument((provided != null && provided.containsKey(name) ? 1 : 0) != 0, (String)"Cannot construct key, missing provided value: %s", (Object[])new Object[]{name});
            return provided.get(name);
        }
        return fp.apply(this.get(object, fp.getSourceName()));
    }
}

