/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.ValidationException;

public class JsonUtil {
    public static JsonNode parse(String json) {
        return JsonUtil.parse(json, JsonNode.class);
    }

    public static <T> T parse(String json, Class<T> returnType) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(json, returnType);
        }
        catch (JsonParseException e) {
            throw new ValidationException("Invalid JSON", e);
        }
        catch (JsonMappingException e) {
            throw new ValidationException("Invalid JSON", e);
        }
        catch (IOException e) {
            throw new DatasetIOException("Cannot initialize JSON parser", e);
        }
    }

    public static JsonNode parse(File file) {
        return JsonUtil.parse(file, JsonNode.class);
    }

    public static <T> T parse(File file, Class<T> returnType) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(file, returnType);
        }
        catch (JsonParseException e) {
            throw new ValidationException("Invalid JSON", e);
        }
        catch (JsonMappingException e) {
            throw new ValidationException("Invalid JSON", e);
        }
        catch (IOException e) {
            throw new DatasetIOException("Cannot initialize JSON parser", e);
        }
    }

    public static JsonNode parse(InputStream in) {
        return JsonUtil.parse(in, JsonNode.class);
    }

    public static <T> T parse(InputStream in, Class<T> returnType) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(in, returnType);
        }
        catch (JsonParseException e) {
            throw new ValidationException("Invalid JSON", e);
        }
        catch (JsonMappingException e) {
            throw new ValidationException("Invalid JSON", e);
        }
        catch (IOException e) {
            throw new DatasetIOException("Cannot initialize JSON parser", e);
        }
    }
}

