/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.MarkerComparator;
import org.kitesdk.data.spi.MarkerRange;
import org.kitesdk.data.spi.Pair;
import org.kitesdk.data.spi.TimeDomain;
import org.kitesdk.data.spi.partition.CalendarFieldPartitioner;
import org.kitesdk.data.spi.predicates.In;
import org.kitesdk.data.spi.predicates.Predicates;
import org.kitesdk.data.spi.predicates.Range;

class KeyRangeIterable
implements Iterable<MarkerRange> {
    private final Map<String, Predicate> predicates;
    private final PartitionStrategy strategy;
    private final MarkerComparator cmp;

    public KeyRangeIterable(PartitionStrategy strategy, Map<String, Predicate> predicates) {
        this.strategy = strategy;
        this.predicates = predicates;
        this.cmp = new MarkerComparator(strategy);
    }

    @Override
    public Iterator<MarkerRange> iterator() {
        LinkedListMultimap partitioners = LinkedListMultimap.create();
        for (FieldPartitioner fp : this.strategy.getFieldPartitioners()) {
            partitioners.put((Object)fp.getSourceName(), (Object)fp);
        }
        Iterator<MarkerRange.Builder> current = KeyRangeIterable.start(new MarkerRange.Builder(this.cmp));
        for (String source : partitioners.keySet()) {
            Predicate constraint = this.predicates.get(source);
            List fps = partitioners.get((Object)source);
            FieldPartitioner first = (FieldPartitioner)fps.get(0);
            if (first instanceof CalendarFieldPartitioner) {
                current = TimeDomain.get(this.strategy, source).addStackedIterator((Predicate<Long>)constraint, current);
                continue;
            }
            if (constraint instanceof In) {
                current = KeyRangeIterable.add((In)constraint, (List<FieldPartitioner>)fps, current);
                continue;
            }
            if (!(constraint instanceof Range)) continue;
            current = KeyRangeIterable.add((Range)constraint, (List<FieldPartitioner>)fps, current);
        }
        return Iterators.transform(current, (Function)new ToMarkerRangeFunction());
    }

    private static <T> Iterator<T> start(T singleton) {
        return Collections.singleton(singleton).iterator();
    }

    static Iterator<MarkerRange.Builder> add(In constraint, List<FieldPartitioner> fps, Iterator<MarkerRange.Builder> inner) {
        Iterator<MarkerRange.Builder> current = inner;
        ArrayList compatible = Lists.newArrayList();
        for (FieldPartitioner fp : fps) {
            Predicate projected = fp.project(constraint);
            if (projected instanceof Range) {
                current = KeyRangeIterable.addProjected(projected, fp.getName(), current);
                continue;
            }
            if (!(projected instanceof In)) continue;
            compatible.add(fp);
        }
        if (compatible.size() < 1) {
            return current;
        }
        if (compatible.size() == 1) {
            FieldPartitioner fp = (FieldPartitioner)compatible.get(0);
            return KeyRangeIterable.addProjected(fp.project(constraint), fp.getName(), current);
        }
        return new SetGroupIterator(constraint, compatible, current);
    }

    static Iterator<MarkerRange.Builder> add(Range constraint, List<FieldPartitioner> fps, Iterator<MarkerRange.Builder> inner) {
        Iterator<MarkerRange.Builder> current = inner;
        ArrayList compatible = Lists.newArrayList();
        for (FieldPartitioner fp : fps) {
            Predicate projected = fp.project(constraint);
            if (projected instanceof In) {
                current = KeyRangeIterable.addProjected(projected, fp.getName(), current);
                continue;
            }
            if (!(projected instanceof Range)) continue;
            compatible.add(Pair.of(fp.getName(), (Range)projected));
        }
        if (compatible.size() < 1) {
            return current;
        }
        if (compatible.size() == 1) {
            Pair pair = (Pair)compatible.get(0);
            return KeyRangeIterable.addProjected((Predicate)pair.second(), (String)pair.first(), current);
        }
        return new RangeGroupIterator(constraint, compatible, current);
    }

    private static Iterator<MarkerRange.Builder> addProjected(Predicate projected, String name, Iterator<MarkerRange.Builder> inner) {
        if (projected instanceof In) {
            return new SetIterator((In)projected, name, inner);
        }
        if (projected instanceof Range) {
            return new RangeIterator(name, (Range)projected, inner);
        }
        return inner;
    }

    static class RangeGroupIterator
    extends StackedIterator<Range, MarkerRange.Builder> {
        private final List<Pair<String, Range>> fields;

        protected RangeGroupIterator(Range constraint, List<Pair<String, Range>> compatible, Iterator<MarkerRange.Builder> inner) {
            this.fields = compatible;
            this.setItem(constraint);
            this.setInner(inner);
        }

        @Override
        public MarkerRange.Builder update(MarkerRange.Builder current, Range range) {
            if (range.hasLowerBound()) {
                for (Pair<String, Range> pair : this.fields) {
                    current.addToStart(pair.first(), pair.second().lowerEndpoint());
                }
            }
            if (range.hasUpperBound()) {
                for (Pair<String, Range> pair : this.fields) {
                    current.addToEnd(pair.first(), pair.second().upperEndpoint());
                }
            }
            return current;
        }
    }

    static class RangeIterator
    extends StackedIterator<Range, MarkerRange.Builder> {
        private final String name;

        protected RangeIterator(String name, Range range, Iterator<MarkerRange.Builder> inner) {
            this.name = name;
            this.setItem(range);
            this.setInner(inner);
        }

        @Override
        public MarkerRange.Builder update(MarkerRange.Builder current, Range range) {
            if (range.hasLowerBound()) {
                current.addToStart(this.name, range.lowerEndpoint());
            }
            if (range.hasUpperBound()) {
                current.addToEnd(this.name, range.upperEndpoint());
            }
            return current;
        }
    }

    static class SetGroupIterator
    extends StackedIterator<Object, MarkerRange.Builder> {
        private final List<FieldPartitioner> fields;

        SetGroupIterator(In constraint, List<FieldPartitioner> fps, Iterator<MarkerRange.Builder> inner) {
            this.fields = fps;
            this.setItems(Predicates.asSet(constraint));
            this.setInner(inner);
        }

        @Override
        public MarkerRange.Builder update(MarkerRange.Builder current, Object item) {
            for (FieldPartitioner fp : this.fields) {
                Object value = fp.apply(item);
                current.addToStart(fp.getName(), value);
                current.addToEnd(fp.getName(), value);
            }
            return current;
        }
    }

    static class SetIterator
    extends StackedIterator<Object, MarkerRange.Builder> {
        private final String name;

        private SetIterator(In projected, String name, Iterator<MarkerRange.Builder> inner) {
            this.name = name;
            this.setItems(Predicates.asSet(projected));
            this.setInner(inner);
        }

        @Override
        public MarkerRange.Builder update(MarkerRange.Builder current, Object item) {
            current.addToStart(this.name, item);
            current.addToEnd(this.name, item);
            return current;
        }
    }

    static abstract class StackedIterator<I, T>
    implements Iterator<T> {
        private Iterable<I> items = null;
        private Iterator<I> iterItems = null;
        private Iterator<T> inner = null;
        private T current = null;

        StackedIterator() {
        }

        protected final void setItem(I item) {
            this.setItems(Collections.singleton(item));
        }

        protected final void setItems(Iterable<I> items) {
            this.items = items;
            this.iterItems = items.iterator();
        }

        protected final void setInner(Iterator<T> inner) {
            Preconditions.checkArgument((boolean)inner.hasNext(), (Object)"Empty iterator");
            this.inner = inner;
            this.current = inner.next();
        }

        @Override
        public boolean hasNext() {
            return this.iterItems.hasNext() || this.inner.hasNext();
        }

        @Override
        public T next() {
            if (this.iterItems.hasNext()) {
                return this.update(this.current, this.iterItems.next());
            }
            if (this.inner.hasNext()) {
                this.current = this.inner.next();
                this.iterItems = this.items.iterator();
                return this.next();
            }
            throw new NoSuchElementException();
        }

        public abstract T update(T var1, I var2);

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported");
        }
    }

    private static class ToMarkerRangeFunction
    implements Function<MarkerRange.Builder, MarkerRange> {
        private ToMarkerRangeFunction() {
        }

        @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="False positive, initialized above as non-null.")
        public MarkerRange apply(@Nullable MarkerRange.Builder builder) {
            return builder.build();
        }
    }
}

