/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificData;
import org.apache.commons.codec.binary.Base64;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.FieldMapping;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.partition.IdentityFieldPartitioner;
import org.kitesdk.data.spi.partition.ProvidedFieldPartitioner;

public class SchemaUtil {
    static final Splitter NAME_SPLITTER = Splitter.on((char)'.');
    static final Joiner NAME_JOINER = Joiner.on((char)'.');
    private static final ImmutableMap<Schema.Type, Class<?>> TYPE_TO_CLASS = ImmutableMap.builder().put((Object)Schema.Type.BOOLEAN, Boolean.class).put((Object)Schema.Type.INT, Integer.class).put((Object)Schema.Type.LONG, Long.class).put((Object)Schema.Type.FLOAT, Float.class).put((Object)Schema.Type.DOUBLE, Double.class).put((Object)Schema.Type.STRING, String.class).put((Object)Schema.Type.BYTES, ByteBuffer.class).build();

    public static Class<?> getClassForType(Schema.Type type) {
        return (Class)TYPE_TO_CLASS.get((Object)type);
    }

    public static <S> Class<? extends S> getSourceType(FieldPartitioner<S, ?> fp, Schema schema) {
        return SchemaUtil.getClassForType(schema.getField(fp.getSourceName()).schema().getType());
    }

    public static <S, T> Class<? extends T> getPartitionType(FieldPartitioner<S, T> fp, Schema schema) {
        if (fp instanceof ProvidedFieldPartitioner) {
            return fp.getType();
        }
        Class<?> inputType = SchemaUtil.getClassForType(schema.getField(fp.getSourceName()).schema().getType());
        return fp.getType(inputType);
    }

    public static boolean isConsistentWithExpectedType(Schema.Type type, Class<?> expectedClass) {
        Class typeClass = (Class)TYPE_TO_CLASS.get((Object)type);
        return typeClass != null && expectedClass.isAssignableFrom(typeClass);
    }

    public static boolean isConsistentWithMappingType(Schema.Type type, FieldMapping.MappingType mappingType) {
        switch (mappingType) {
            case COUNTER: 
            case OCC_VERSION: {
                return type == Schema.Type.INT || type == Schema.Type.LONG;
            }
            case KEY_AS_COLUMN: {
                return type == Schema.Type.MAP || type == Schema.Type.RECORD;
            }
            case KEY: {
                return TYPE_TO_CLASS.containsKey((Object)type);
            }
        }
        return true;
    }

    public static void checkTypeConsistency(Schema schema, String fieldName, Object ... values) {
        SchemaUtil.checkTypeConsistency(schema, null, fieldName, values);
    }

    public static void checkTypeConsistency(Schema schema, PartitionStrategy strategy, String fieldName, Object ... values) {
        Schema fieldSchema = SchemaUtil.fieldSchema(schema, strategy, fieldName);
        for (Object value : values) {
            Preconditions.checkArgument((boolean)SpecificData.get().validate(fieldSchema, value), (String)"Value '%s' of type '%s' inconsistent with field schema %s.", (Object[])new Object[]{value, value.getClass(), fieldSchema});
        }
    }

    public static Schema partitionFieldSchema(FieldPartitioner<?, ?> fp, Schema schema) {
        if (fp instanceof IdentityFieldPartitioner) {
            return schema.getField(fp.getSourceName()).schema();
        }
        Class<?> fieldType = SchemaUtil.getPartitionType(fp, schema);
        if (fieldType == Integer.class) {
            return Schema.create((Schema.Type)Schema.Type.INT);
        }
        if (fieldType == Long.class) {
            return Schema.create((Schema.Type)Schema.Type.LONG);
        }
        if (fieldType == String.class) {
            return Schema.create((Schema.Type)Schema.Type.STRING);
        }
        throw new ValidationException("Cannot encode partition " + fp.getName() + " with type " + fp.getSourceType());
    }

    public static boolean isField(Schema schema, PartitionStrategy strategy, String name) {
        Schema.Field field = schema.getField(name);
        return field != null || strategy != null && strategy.hasPartitioner(name);
    }

    public static Schema fieldSchema(Schema schema, PartitionStrategy strategy, String name) {
        if (strategy != null && strategy.hasPartitioner(name)) {
            return SchemaUtil.partitionFieldSchema(strategy.getPartitioner(name), schema);
        }
        Schema nested = SchemaUtil.fieldSchema(schema, name);
        if (nested != null) {
            return nested;
        }
        throw new IllegalArgumentException("Not a schema or partition field: " + name);
    }

    public static Schema fieldSchema(Schema schema, String name) {
        Schema nested = schema;
        ArrayList levels = Lists.newArrayList();
        for (String level : NAME_SPLITTER.split((CharSequence)name)) {
            levels.add(level);
            Preconditions.checkArgument((Schema.Type.RECORD == schema.getType() ? 1 : 0) != 0, (String)"Cannot get schema for %s: %s is not a record schema: %s", (Object[])new Object[]{name, NAME_JOINER.join((Iterable)levels), nested.toString(true)});
            Schema.Field field = nested.getField(level);
            Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Cannot get schema for %s: %s is not a field", (Object[])new Object[]{name, NAME_JOINER.join((Iterable)levels)});
            nested = field.schema();
        }
        return nested;
    }

    public static Schema keySchema(Schema schema, PartitionStrategy strategy) {
        ArrayList<Schema.Field> partitionFields = new ArrayList<Schema.Field>();
        for (FieldPartitioner fp : strategy.getFieldPartitioners()) {
            partitionFields.add(SchemaUtil.partitionField(fp, schema));
        }
        Schema keySchema = Schema.createRecord((String)(schema.getName() + "KeySchema"), null, null, (boolean)false);
        keySchema.setFields(partitionFields);
        return keySchema;
    }

    private static Schema.Field partitionField(FieldPartitioner<?, ?> fp, Schema schema) {
        return new Schema.Field(fp.getName(), SchemaUtil.partitionFieldSchema(fp, schema), null, null);
    }

    public static void checkPartitionedBy(DatasetDescriptor descriptor, String fieldName) {
        Preconditions.checkArgument((boolean)descriptor.isPartitioned(), (String)"Descriptor %s is not partitioned", (Object[])new Object[]{descriptor});
        Preconditions.checkArgument((boolean)descriptor.getPartitionStrategy().hasPartitioner(fieldName), (String)"Descriptor %s is not partitioned by '%s'", (Object[])new Object[]{descriptor, fieldName});
    }

    public static <T> T visit(Schema schema, SchemaVisitor<T> visitor) {
        switch (schema.getType()) {
            case RECORD: {
                String name = schema.getFullName();
                Preconditions.checkState((!visitor.recordLevels.contains(name) ? 1 : 0) != 0, (String)"Cannot process recursive Avro record %s", (Object[])new Object[]{name});
                visitor.recordLevels.push(name);
                List fields = schema.getFields();
                ArrayList names = Lists.newArrayListWithExpectedSize((int)fields.size());
                ArrayList results = Lists.newArrayListWithExpectedSize((int)fields.size());
                for (Schema.Field field : schema.getFields()) {
                    names.add(field.name());
                    results.add(SchemaUtil.visit(field.schema(), visitor));
                }
                visitor.recordLevels.pop();
                return visitor.record(schema, names, results);
            }
            case UNION: {
                List types = schema.getTypes();
                ArrayList options = Lists.newArrayListWithExpectedSize((int)types.size());
                for (Schema type : types) {
                    options.add(SchemaUtil.visit(type, visitor));
                }
                return visitor.union(schema, options);
            }
            case ARRAY: {
                return visitor.array(schema, SchemaUtil.visit(schema.getElementType(), visitor));
            }
            case MAP: {
                return visitor.map(schema, SchemaUtil.visit(schema.getValueType(), visitor));
            }
        }
        return visitor.primitive(schema);
    }

    public static String toString(Object value, Schema schema) {
        switch (schema.getType()) {
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return value.toString();
            }
            case STRING: {
                try {
                    return URLEncoder.encode(value.toString(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new DatasetIOException("Failed to encode value: " + value, e);
                }
            }
        }
        DatumWriter writer = ReflectData.get().createDatumWriter(schema);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)out, null);
        try {
            writer.write(value, (Encoder)encoder);
            encoder.flush();
        }
        catch (IOException e) {
            throw new DatasetIOException("Cannot encode Avro value", e);
        }
        return Base64.encodeBase64URLSafeString((byte[])out.toByteArray());
    }

    public static <T> T fromString(String value, Schema schema) {
        switch (schema.getType()) {
            case BOOLEAN: {
                return (T)Boolean.valueOf(value);
            }
            case INT: {
                return (T)Integer.valueOf(value);
            }
            case LONG: {
                return (T)Long.valueOf(value);
            }
            case FLOAT: {
                return (T)Float.valueOf(value);
            }
            case DOUBLE: {
                return (T)Double.valueOf(value);
            }
            case STRING: {
                try {
                    return (T)URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new DatasetIOException("Failed to decode value: " + value, e);
                }
            }
        }
        byte[] binary = Base64.decodeBase64((String)value);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)new ByteArrayInputStream(binary), null);
        DatumReader reader = ReflectData.get().createDatumReader(schema);
        try {
            return (T)reader.read(null, (Decoder)decoder);
        }
        catch (IOException e) {
            throw new DatasetIOException("Cannot decode Avro value", e);
        }
    }

    public static abstract class SchemaVisitor<T> {
        protected LinkedList<String> recordLevels = Lists.newLinkedList();

        public T record(Schema record, List<String> names, List<T> fields) {
            return null;
        }

        public T union(Schema union, List<T> options) {
            return null;
        }

        public T array(Schema array, T element) {
            return null;
        }

        public T map(Schema map, T value) {
            return null;
        }

        public T primitive(Schema primitive) {
            return null;
        }
    }
}

