/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.spi.Conversions;
import org.kitesdk.data.spi.EntityAccessor;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.Marker;

public class StorageKey
extends Marker
implements Comparable<StorageKey> {
    private static final LoadingCache<PartitionStrategy, Map<String, Integer>> FIELD_CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<PartitionStrategy, Map<String, Integer>>(){

        public Map<String, Integer> load(PartitionStrategy strategy) {
            List<FieldPartitioner> fields = strategy.getFieldPartitioners();
            HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)fields.size());
            int n = fields.size();
            for (int i = 0; i < n; ++i) {
                fieldMap.put(fields.get(i).getName(), i);
            }
            return fieldMap;
        }
    });
    private final PartitionStrategy strategy;
    private final Map<String, Integer> fields;
    private List<Object> values;

    public StorageKey(PartitionStrategy strategy) {
        this(strategy, Arrays.asList(new Object[strategy.getFieldPartitioners().size()]));
    }

    private StorageKey(PartitionStrategy strategy, List<Object> values) {
        try {
            this.fields = (Map)FIELD_CACHE.get((Object)strategy);
        }
        catch (ExecutionException ex) {
            throw new RuntimeException("[BUG] Could not get field map");
        }
        Preconditions.checkArgument((values.size() == this.fields.size() ? 1 : 0) != 0, (Object)"Not enough values for a complete StorageKey");
        this.strategy = strategy;
        this.values = values;
    }

    public PartitionStrategy getPartitionStrategy() {
        return this.strategy;
    }

    @Override
    public boolean has(String name) {
        return this.fields.containsKey(name);
    }

    @Override
    public Object get(String name) {
        return this.values.get(this.fields.get(name));
    }

    public Object get(int index) {
        return this.values.get(index);
    }

    public void replace(int index, Object value) {
        this.values.set(index, value);
    }

    public void replaceValues(List<Object> values) {
        Preconditions.checkArgument((values != null ? 1 : 0) != 0, (Object)"Values cannot be null");
        Preconditions.checkArgument((values.size() == this.fields.size() ? 1 : 0) != 0, (Object)"Not enough values for a complete StorageKey");
        this.values = values;
    }

    public <E> StorageKey reuseFor(E entity, EntityAccessor<E> accessor) {
        List<FieldPartitioner> partitioners = this.strategy.getFieldPartitioners();
        for (int i = 0; i < partitioners.size(); ++i) {
            FieldPartitioner fp = partitioners.get(i);
            this.replace(i, fp.apply(accessor.get(entity, fp.getSourceName())));
        }
        return this;
    }

    @Override
    public int compareTo(StorageKey other) {
        if (other == null) {
            throw new NullPointerException("Cannot compare a StorageKey with null");
        }
        if (!this.strategy.equals(other.strategy)) {
            throw new RuntimeException("PartitionStrategy does not match");
        }
        List<FieldPartitioner> partitioners = this.strategy.getFieldPartitioners();
        for (int i = 0; i < partitioners.size(); ++i) {
            FieldPartitioner fp = partitioners.get(i);
            int cmp = fp.compare(this.get(i), other.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.values});
    }

    public boolean equals(Object obj) {
        if (obj instanceof StorageKey) {
            return Objects.equal(this.values, ((StorageKey)obj).values);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("values", this.values).toString();
    }

    public static StorageKey copy(StorageKey toCopy) {
        return new StorageKey(toCopy.strategy, Lists.newArrayList(toCopy.values));
    }

    @VisibleForTesting
    public static class Builder {
        private final PartitionStrategy strategy;
        private final Map<String, Object> values;

        public Builder(PartitionStrategy strategy) {
            this.strategy = strategy;
            this.values = Maps.newHashMap();
        }

        public Builder(Dataset dataset) {
            if (!dataset.getDescriptor().isPartitioned()) {
                throw new DatasetException("Dataset is not partitioned");
            }
            this.strategy = dataset.getDescriptor().getPartitionStrategy();
            this.values = Maps.newHashMap();
        }

        public Builder add(String name, Object value) {
            this.values.put(name, value);
            return this;
        }

        public StorageKey build() {
            List<FieldPartitioner> partitioners = this.strategy.getFieldPartitioners();
            ArrayList content = Lists.newArrayListWithCapacity((int)partitioners.size());
            for (FieldPartitioner fp : partitioners) {
                content.add(this.valueFor(fp));
            }
            return new StorageKey(this.strategy, content);
        }

        private <S, T> T valueFor(FieldPartitioner<S, T> fp) {
            if (this.values.containsKey(fp.getName())) {
                return Conversions.convert(this.values.get(fp.getName()), fp.getType());
            }
            if (this.values.containsKey(fp.getSourceName())) {
                return fp.apply(Conversions.convert(this.values.get(fp.getSourceName()), fp.getSourceType()));
            }
            throw new IllegalStateException("Cannot create StorageKey, missing data for field:" + fp.getName());
        }
    }
}

