/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.reflect.ReflectData;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetReaderException;
import org.kitesdk.data.spi.AbstractDatasetReader;
import org.kitesdk.data.spi.EntityAccessor;
import org.kitesdk.data.spi.ReaderWriterState;
import org.kitesdk.data.spi.filesystem.CSVProperties;
import org.kitesdk.data.spi.filesystem.CSVUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CSVFileReader<E>
extends AbstractDatasetReader<E> {
    private static final Logger LOG = LoggerFactory.getLogger(CSVFileReader.class);
    private final CSVProperties props;
    private final FileSystem fs;
    private final Path path;
    private final Schema schema;
    private final Class<E> recordClass;
    private CSVReader reader = null;
    private long size = 0L;
    private FSDataInputStream incoming = null;
    private ReaderWriterState state = ReaderWriterState.NEW;
    private boolean hasNext = false;
    private String[] next = null;
    private Schema.Field[] fields = null;
    private int[] indexes = null;

    public CSVFileReader(FileSystem fileSystem, Path path, DatasetDescriptor descriptor, EntityAccessor<E> accessor) {
        this.fs = fileSystem;
        this.path = path;
        this.schema = accessor.getEntitySchema();
        this.recordClass = accessor.getType();
        this.state = ReaderWriterState.NEW;
        this.props = CSVProperties.fromDescriptor(descriptor);
        Preconditions.checkArgument((boolean)Schema.Type.RECORD.equals((Object)this.schema.getType()), (Object)"Schemas for CSV files must be records of primitive types");
    }

    @Override
    public void initialize() {
        Preconditions.checkState((boolean)this.state.equals((Object)ReaderWriterState.NEW), (String)"A reader may not be opened more than once - current state:%s", (Object[])new Object[]{this.state});
        try {
            this.incoming = this.fs.open(this.path);
            this.size = this.fs.getFileStatus(this.path).getLen();
        }
        catch (IOException ex) {
            throw new DatasetReaderException("Cannot open path: " + this.path, ex);
        }
        this.reader = CSVUtil.newReader((InputStream)this.incoming, this.props);
        if (this.props.useHeader) {
            this.hasNext = this.advance();
        }
        this.fields = this.schema.getFields().toArray(new Schema.Field[this.schema.getFields().size()]);
        this.indexes = new int[this.fields.length];
        if (this.next != null) {
            int i;
            for (i = 0; i < this.fields.length; ++i) {
                this.fields[i] = (Schema.Field)this.schema.getFields().get(i);
                this.indexes[i] = Integer.MAX_VALUE;
            }
            for (i = 0; i < this.next.length; ++i) {
                Schema.Field field = this.schema.getField(this.next[i]);
                if (field == null) continue;
                this.indexes[field.pos()] = i;
            }
        } else {
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = (Schema.Field)this.schema.getFields().get(i);
                this.indexes[i] = i;
            }
        }
        this.hasNext = this.advance();
        this.state = ReaderWriterState.OPEN;
    }

    @Override
    public boolean hasNext() {
        Preconditions.checkState((boolean)this.state.equals((Object)ReaderWriterState.OPEN), (String)"Attempt to read from a file in state:%s", (Object[])new Object[]{this.state});
        return this.hasNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E next() {
        Preconditions.checkState((boolean)this.state.equals((Object)ReaderWriterState.OPEN), (String)"Attempt to read from a file in state:%s", (Object[])new Object[]{this.state});
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        try {
            E record;
            E e = record = this.makeRecord();
            return e;
        }
        finally {
            this.hasNext = this.advance();
        }
    }

    private boolean advance() {
        try {
            this.next = this.reader.readNext();
        }
        catch (IOException ex) {
            throw new DatasetReaderException("Could not read record", ex);
        }
        return this.next != null;
    }

    @Override
    public void close() {
        if (!this.state.equals((Object)ReaderWriterState.OPEN)) {
            return;
        }
        LOG.debug("Closing reader on path:{}", (Object)this.path);
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new DatasetReaderException("Unable to close reader path:" + this.path, e);
        }
        this.state = ReaderWriterState.CLOSED;
    }

    @Override
    public boolean isOpen() {
        return this.state == ReaderWriterState.OPEN;
    }

    private E makeRecord() {
        E record;
        if (this.recordClass != GenericData.Record.class && !this.recordClass.isInterface() && (record = this.makeReflectRecord()) != null) {
            return record;
        }
        return this.makeGenericRecord();
    }

    private E makeGenericRecord() {
        GenericData.Record record = new GenericData.Record(this.schema);
        this.fillIndexed((IndexedRecord)record, this.next);
        return (E)record;
    }

    private E makeReflectRecord() {
        ReflectData.get();
        Object record = ReflectData.newInstance(this.recordClass, (Schema)this.schema);
        if (record instanceof IndexedRecord) {
            this.fillIndexed((IndexedRecord)record, this.next);
        } else {
            this.fillReflect(record, this.next);
        }
        return (E)record;
    }

    private void fillIndexed(IndexedRecord record, String[] data) {
        for (int i = 0; i < this.indexes.length; ++i) {
            int index = this.indexes[i];
            record.put(i, CSVFileReader.makeValue(index < data.length ? data[index] : null, this.fields[i]));
        }
    }

    private void fillReflect(Object record, String[] data) {
        for (int i = 0; i < this.indexes.length; ++i) {
            Schema.Field field = this.fields[i];
            int index = this.indexes[i];
            Object value = CSVFileReader.makeValue(index < data.length ? data[index] : null, field);
            ReflectData.get().setField(record, field.name(), i, value);
        }
    }

    private static Object makeValue(@Nullable String string, Schema.Field field) {
        Object value = CSVFileReader.makeValue(string, field.schema());
        if (value != null || CSVFileReader.nullOk(field.schema())) {
            return value;
        }
        return ReflectData.get().getDefaultValue(field);
    }

    private static Object makeValue(@Nullable String string, Schema schema) {
        if (string == null) {
            return null;
        }
        try {
            switch (schema.getType()) {
                case BOOLEAN: {
                    return Boolean.valueOf(string);
                }
                case STRING: {
                    return string;
                }
                case FLOAT: {
                    return Float.valueOf(string);
                }
                case DOUBLE: {
                    return Double.valueOf(string);
                }
                case INT: {
                    return Integer.valueOf(string);
                }
                case LONG: {
                    return Long.valueOf(string);
                }
                case ENUM: {
                    if (schema.hasEnumSymbol(string)) {
                        return string;
                    }
                    try {
                        return schema.getEnumSymbols().get(Integer.valueOf(string));
                    }
                    catch (IndexOutOfBoundsException ex) {
                        return null;
                    }
                }
                case UNION: {
                    Object value = null;
                    for (Schema possible : schema.getTypes()) {
                        value = CSVFileReader.makeValue(string, possible);
                        if (value == null) continue;
                        return value;
                    }
                    return null;
                }
                case NULL: {
                    return null;
                }
            }
            throw new DatasetReaderException("Unsupported field type:" + schema.getType());
        }
        catch (NumberFormatException e) {
            if (string.isEmpty()) {
                return null;
            }
            throw e;
        }
    }

    private static boolean nullOk(Schema schema) {
        if (Schema.Type.NULL == schema.getType()) {
            return true;
        }
        if (Schema.Type.UNION == schema.getType()) {
            for (Schema possible : schema.getTypes()) {
                if (!CSVFileReader.nullOk(possible)) continue;
                return true;
            }
        }
        return false;
    }

    public RecordReader<E, Void> asRecordReader() {
        return new CSVRecordReader();
    }

    public class CSVRecordReader
    extends RecordReader<E, Void> {
        private E current;

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            if (CSVFileReader.this.hasNext()) {
                this.current = CSVFileReader.this.next();
                return true;
            }
            return false;
        }

        public E getCurrentKey() throws IOException, InterruptedException {
            return this.current;
        }

        public Void getCurrentValue() throws IOException, InterruptedException {
            return null;
        }

        public float getProgress() throws IOException, InterruptedException {
            return (float)CSVFileReader.this.incoming.getPos() / (float)CSVFileReader.this.size;
        }

        public void close() throws IOException {
            CSVFileReader.this.close();
        }
    }
}

