/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.NullNode;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.spi.Compatibility;
import org.kitesdk.data.spi.filesystem.CSVProperties;

public class CSVUtil {
    private static final Pattern LONG = Pattern.compile("\\d+");
    private static final Pattern DOUBLE = Pattern.compile("\\d*\\.\\d*[dD]?");
    private static final Pattern FLOAT = Pattern.compile("\\d*\\.\\d*[fF]?");
    private static final int DEFAULT_INFER_LINES = 25;
    private static final Set<String> NO_REQUIRED_FIELDS = ImmutableSet.of();
    private static final CharMatcher NON_PRINTABLE = CharMatcher.inRange((char)' ', (char)'~').negate();

    public static CSVReader newReader(InputStream incoming, CSVProperties props) {
        return new CSVReader((Reader)new InputStreamReader(incoming, Charset.forName(props.charset)), props.delimiter.charAt(0), props.quote.charAt(0), props.escape.charAt(0), props.linesToSkip, false, true);
    }

    public static CSVWriter newWriter(OutputStream outgoing, CSVProperties props) {
        return new CSVWriter((Writer)new OutputStreamWriter(outgoing, Charset.forName(props.charset)), props.delimiter.charAt(0), props.quote.charAt(0), props.escape.charAt(0));
    }

    public static Schema inferNullableSchema(String name, InputStream incoming, CSVProperties props) throws IOException {
        return CSVUtil.inferSchemaInternal(name, incoming, props, NO_REQUIRED_FIELDS, true);
    }

    public static Schema inferNullableSchema(String name, InputStream incoming, CSVProperties props, Set<String> requiredFields) throws IOException {
        return CSVUtil.inferSchemaInternal(name, incoming, props, requiredFields, true);
    }

    public static Schema inferSchema(String name, InputStream incoming, CSVProperties props) throws IOException {
        return CSVUtil.inferSchemaInternal(name, incoming, props, NO_REQUIRED_FIELDS, false);
    }

    public static Schema inferSchema(String name, InputStream incoming, CSVProperties props, Set<String> requiredFields) throws IOException {
        return CSVUtil.inferSchemaInternal(name, incoming, props, requiredFields, false);
    }

    private static Schema inferSchemaInternal(String name, InputStream incoming, CSVProperties props, Set<String> requiredFields, boolean makeNullable) throws IOException {
        int i;
        String[] line;
        String[] header;
        CSVReader reader = CSVUtil.newReader(incoming, props);
        if (props.useHeader) {
            header = reader.readNext();
            line = reader.readNext();
            Preconditions.checkNotNull((Object)line, (Object)"No content to infer schema");
        } else {
            line = reader.readNext();
            Preconditions.checkNotNull((Object)line, (Object)"No content to infer schema");
            header = new String[line.length];
            for (int i2 = 0; i2 < line.length; ++i2) {
                header[i2] = "field_" + String.valueOf(i2);
            }
        }
        Schema.Type[] types = new Schema.Type[header.length];
        String[] values = new String[header.length];
        boolean[] nullable = new boolean[header.length];
        boolean[] empty = new boolean[header.length];
        for (int processed = 0; processed < 25 && line != null; ++processed) {
            for (i = 0; i < header.length; ++i) {
                if (i < line.length) {
                    if (types[i] == null) {
                        types[i] = CSVUtil.inferFieldType(line[i]);
                        if (types[i] != null) {
                            values[i] = line[i];
                        }
                    }
                    if (line[i] == null) {
                        nullable[i] = true;
                        continue;
                    }
                    if (!line[i].isEmpty()) continue;
                    empty[i] = true;
                    continue;
                }
                nullable[i] = true;
            }
            line = reader.readNext();
        }
        ArrayList fields = Lists.newArrayList();
        for (i = 0; i < header.length; ++i) {
            boolean foundNull;
            if (header[i] == null) {
                throw new DatasetException("Bad header for field " + i + ": null");
            }
            String fieldName = header[i].trim();
            if (fieldName.isEmpty()) {
                throw new DatasetException("Bad header for field " + i + ": \"" + fieldName + "\"");
            }
            if (!Compatibility.isAvroCompatibleName(fieldName)) {
                throw new DatasetException("Bad header for field, should start with a character or _ and can contain only alphanumerics and _ " + i + ": \"" + fieldName + "\"");
            }
            boolean bl = foundNull = nullable[i] || empty[i] && types[i] != Schema.Type.STRING;
            if (requiredFields.contains(fieldName)) {
                if (foundNull) {
                    throw new DatasetException("Found null value for required field: " + fieldName + " (" + types[i] + ")");
                }
                fields.add(new Schema.Field(fieldName, CSVUtil.schema(types[i], false), "Type inferred from '" + CSVUtil.sample(values[i]) + "'", null));
                continue;
            }
            fields.add(new Schema.Field(fieldName, CSVUtil.schema(types[i], makeNullable || foundNull), "Type inferred from '" + CSVUtil.sample(values[i]) + "'", (JsonNode)(makeNullable || foundNull ? NullNode.getInstance() : null)));
        }
        Schema record = Schema.createRecord((String)name, (String)"Schema generated by Kite", null, (boolean)false);
        record.setFields((List)fields);
        return record;
    }

    @VisibleForTesting
    static String sample(@Nullable String value) {
        if (value != null) {
            return NON_PRINTABLE.replaceFrom(value.subSequence(0, Math.min(50, value.length())), '.');
        }
        return "null";
    }

    private static Schema schema(Schema.Type type, boolean makeNullable) {
        Schema schema = Schema.create((Schema.Type)(type == null ? Schema.Type.STRING : type));
        if (makeNullable || type == null) {
            schema = Schema.createUnion((List)Lists.newArrayList((Object[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), schema}));
        }
        return schema;
    }

    private static Schema.Type inferFieldType(String example) {
        if (example == null || example.isEmpty()) {
            return null;
        }
        if (LONG.matcher(example).matches()) {
            return Schema.Type.LONG;
        }
        if (DOUBLE.matcher(example).matches()) {
            return Schema.Type.DOUBLE;
        }
        if (FLOAT.matcher(example).matches()) {
            return Schema.Type.FLOAT;
        }
        return Schema.Type.STRING;
    }
}

