/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.Formats;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.RefinableView;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.AbstractDataset;
import org.kitesdk.data.spi.Compatibility;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.InputFormatAccessor;
import org.kitesdk.data.spi.LastModifiedAccessor;
import org.kitesdk.data.spi.Mergeable;
import org.kitesdk.data.spi.PartitionKey;
import org.kitesdk.data.spi.PartitionListener;
import org.kitesdk.data.spi.PartitionedDataset;
import org.kitesdk.data.spi.SizeAccessor;
import org.kitesdk.data.spi.filesystem.FileSystemView;
import org.kitesdk.data.spi.filesystem.FileSystemViewKeyInputFormat;
import org.kitesdk.data.spi.filesystem.PathConversion;
import org.kitesdk.data.spi.filesystem.PathFilters;
import org.kitesdk.data.spi.filesystem.PathIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemDataset<E>
extends AbstractDataset<E>
implements Mergeable<FileSystemDataset<E>>,
InputFormatAccessor<E>,
LastModifiedAccessor,
PartitionedDataset<E>,
SizeAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemDataset.class);
    private final FileSystem fileSystem;
    private final Path directory;
    private final String namespace;
    private final String name;
    private final DatasetDescriptor descriptor;
    private PartitionKey partitionKey;
    private final URI uri;
    private final PartitionStrategy partitionStrategy;
    private final PartitionListener partitionListener;
    private final FileSystemView<E> unbounded;
    private final PathConversion convert;

    FileSystemDataset(FileSystem fileSystem, Path directory, String namespace, String name, DatasetDescriptor descriptor, URI uri, @Nullable PartitionListener partitionListener, Class<E> type) {
        super(type, descriptor.getSchema());
        if (Formats.PARQUET.equals(descriptor.getFormat())) {
            Preconditions.checkArgument((IndexedRecord.class.isAssignableFrom(type) || type == Object.class ? 1 : 0) != 0, (Object)"Parquet only supports generic and specific data models, type parameter must implement IndexedRecord");
        }
        this.fileSystem = fileSystem;
        this.directory = directory;
        this.namespace = namespace;
        this.name = name;
        this.descriptor = descriptor;
        this.partitionStrategy = descriptor.isPartitioned() ? descriptor.getPartitionStrategy() : null;
        this.partitionListener = partitionListener;
        this.convert = new PathConversion(descriptor.getSchema());
        this.uri = uri;
        this.unbounded = new FileSystemView<E>(this, type);
        this.partitionKey = null;
    }

    FileSystemDataset(FileSystem fileSystem, Path directory, String namespace, String name, DatasetDescriptor descriptor, URI uri, @Nullable PartitionKey partitionKey, @Nullable PartitionListener partitionListener, Class<E> type) {
        this(fileSystem, directory, namespace, name, descriptor, uri, partitionListener, type);
        this.partitionKey = partitionKey;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DatasetDescriptor getDescriptor() {
        return this.descriptor;
    }

    PartitionKey getPartitionKey() {
        return this.partitionKey;
    }

    FileSystem getFileSystem() {
        return this.fileSystem;
    }

    Path getDirectory() {
        return this.directory;
    }

    PartitionListener getPartitionListener() {
        return this.partitionListener;
    }

    @Override
    public boolean deleteAll() {
        return this.unbounded.deleteAllUnsafe();
    }

    public PathIterator pathIterator() {
        return this.unbounded.pathIterator();
    }

    public Iterator<Path> dirIterator() {
        return this.unbounded.dirIterator();
    }

    @Override
    protected RefinableView<E> asRefinableView() {
        return this.unbounded;
    }

    @Override
    public FileSystemView<E> filter(Constraints c) {
        return this.unbounded.filter(c);
    }

    @Override
    @Nullable
    public PartitionedDataset<E> getPartition(PartitionKey key, boolean allowCreate) {
        Path partitionDirectory;
        block4: {
            Preconditions.checkState((boolean)this.descriptor.isPartitioned(), (String)"Attempt to get a partition on a non-partitioned dataset (name:%s)", (Object[])new Object[]{this.name});
            LOG.debug("Loading partition for key {}, allowCreate:{}", new Object[]{key, allowCreate});
            partitionDirectory = this.fileSystem.makeQualified(this.toDirectoryName(this.directory, key));
            try {
                if (this.fileSystem.exists(partitionDirectory)) break block4;
                if (allowCreate) {
                    this.fileSystem.mkdirs(partitionDirectory);
                    if (this.partitionListener != null) {
                        this.partitionListener.partitionAdded(this.namespace, this.name, this.toRelativeDirectory(key).toString());
                    }
                    break block4;
                }
                return null;
            }
            catch (IOException e) {
                throw new DatasetIOException("Unable to locate or create dataset partition directory " + partitionDirectory, e);
            }
        }
        int partitionDepth = key.getLength();
        PartitionStrategy subpartitionStrategy = Accessor.getDefault().getSubpartitionStrategy(this.partitionStrategy, partitionDepth);
        return new Builder().namespace(this.namespace).name(this.name).fileSystem(this.fileSystem).uri(this.uri).descriptor(new DatasetDescriptor.Builder(this.descriptor).location(partitionDirectory).partitionStrategy(subpartitionStrategy).build()).type(this.type).partitionKey(key).partitionListener(this.partitionListener).build();
    }

    @Override
    public void dropPartition(PartitionKey key) {
        Preconditions.checkState((boolean)this.descriptor.isPartitioned(), (String)"Attempt to drop a partition on a non-partitioned dataset (name:%s)", (Object[])new Object[]{this.name});
        Preconditions.checkNotNull((Object)key, (Object)"Partition key may not be null");
        LOG.debug("Dropping partition with key:{} dataset:{}", (Object)key, (Object)this.name);
        Path partitionDirectory = this.toDirectoryName(this.directory, key);
        try {
            if (!this.fileSystem.delete(partitionDirectory, true)) {
                throw new IOException("Partition directory " + partitionDirectory + " for key " + key + " does not exist");
            }
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to locate or drop dataset partition directory " + partitionDirectory, e);
        }
    }

    @Override
    public Iterable<PartitionedDataset<E>> getPartitions() {
        FileStatus[] fileStatuses;
        Preconditions.checkState((boolean)this.descriptor.isPartitioned(), (String)"Attempt to get partitions on a non-partitioned dataset (name:%s)", (Object[])new Object[]{this.name});
        ArrayList partitions = Lists.newArrayList();
        try {
            fileStatuses = this.fileSystem.listStatus(this.directory, PathFilters.notHidden());
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to list partition directory for directory " + this.directory, e);
        }
        for (FileStatus stat : fileStatuses) {
            Path p = this.fileSystem.makeQualified(stat.getPath());
            PartitionKey key = this.keyFromDirectory(p.getName());
            PartitionStrategy subPartitionStrategy = Accessor.getDefault().getSubpartitionStrategy(this.partitionStrategy, 1);
            Builder builder = new Builder().namespace(this.namespace).name(this.name).fileSystem(this.fileSystem).uri(this.uri).descriptor(new DatasetDescriptor.Builder(this.descriptor).location(p).partitionStrategy(subPartitionStrategy).build()).type(this.type).partitionKey(key).partitionListener(this.partitionListener);
            partitions.add(builder.build());
        }
        return partitions;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("descriptor", (Object)this.descriptor).add("directory", (Object)this.directory).add("dataDirectory", (Object)this.directory).add("partitionKey", (Object)this.partitionKey).toString();
    }

    @Override
    public void merge(FileSystemDataset<E> update) {
        DatasetDescriptor updateDescriptor = update.getDescriptor();
        Compatibility.checkCompatible(updateDescriptor, this.descriptor);
        HashSet addedPartitions = Sets.newHashSet();
        for (Path path : update.pathIterator()) {
            String partition;
            URI relativePath = update.getDirectory().toUri().relativize(path.toUri());
            Path newPath = relativePath.toString().isEmpty() ? this.directory : new Path(this.directory, new Path(relativePath));
            Path newPartitionDirectory = newPath.getParent();
            try {
                if (!this.fileSystem.exists(newPartitionDirectory)) {
                    this.fileSystem.mkdirs(newPartitionDirectory);
                }
                LOG.debug("Renaming {} to {}", (Object)path, (Object)newPath);
                boolean renameOk = this.fileSystem.rename(path, newPath);
                if (!renameOk) {
                    throw new IOException("Dataset merge failed during rename of " + path + " to " + newPath);
                }
            }
            catch (IOException e) {
                throw new DatasetIOException("Dataset merge failed", e);
            }
            if (!this.descriptor.isPartitioned() || this.partitionListener == null || addedPartitions.contains(partition = newPartitionDirectory.toString())) continue;
            this.partitionListener.partitionAdded(this.namespace, this.name, partition);
            addedPartitions.add(partition);
        }
    }

    @Override
    public InputFormat<E, Void> getInputFormat(Configuration conf) {
        return new FileSystemViewKeyInputFormat(this, conf);
    }

    private Path toDirectoryName(@Nullable Path dir, PartitionKey key) {
        Path result = dir;
        for (int i = 0; i < key.getLength(); ++i) {
            FieldPartitioner fp = this.partitionStrategy.getFieldPartitioners().get(i);
            result = result != null ? new Path(result, PathConversion.dirnameForValue(fp, key.get(i))) : new Path(PathConversion.dirnameForValue(fp, key.get(i)));
        }
        return result;
    }

    private Path toRelativeDirectory(PartitionKey key) {
        return this.toDirectoryName(null, key);
    }

    private PartitionKey keyFromDirectory(String name) {
        FieldPartitioner fp = this.partitionStrategy.getFieldPartitioners().get(0);
        ArrayList values = Lists.newArrayList();
        if (this.partitionKey != null) {
            values.addAll(this.partitionKey.getValues());
        }
        values.add(this.convert.valueForDirname(fp, name));
        return new PartitionKey(values.toArray());
    }

    public PartitionKey keyFromDirectory(Path dir) {
        Path relDir = null;
        URI relUri = this.directory.toUri().relativize(dir.toUri());
        if (!relUri.toString().isEmpty()) {
            relDir = new Path(relUri);
            Preconditions.checkState((!relDir.equals((Object)dir) ? 1 : 0) != 0, (String)"Partition directory %s is not relative to dataset directory %s", (Object[])new Object[]{dir, this.directory});
        }
        ArrayList pathComponents = Lists.newArrayList();
        while (relDir != null && !relDir.getName().equals("")) {
            pathComponents.add(0, relDir.getName());
            relDir = relDir.getParent();
        }
        List<FieldPartitioner> fps = this.partitionStrategy.getFieldPartitioners();
        Preconditions.checkState((pathComponents.size() <= fps.size() ? 1 : 0) != 0, (String)"Number of components in partition directory %s (%s) exceeds number of field partitioners %s", (Object[])new Object[]{dir, pathComponents, this.partitionStrategy});
        ArrayList values = Lists.newArrayList();
        for (int i = 0; i < pathComponents.size(); ++i) {
            values.add(this.convert.valueForDirname(fps.get(i), (String)pathComponents.get(i)));
        }
        if (this.partitionKey != null) {
            values.addAll(0, this.partitionKey.getValues());
        }
        return new PartitionKey(values.toArray());
    }

    @Override
    public long getSize() {
        long size = 0L;
        Iterator<Path> i = this.dirIterator();
        while (i.hasNext()) {
            Path dir = i.next();
            try {
                for (FileStatus st : this.fileSystem.listStatus(dir)) {
                    size += st.getLen();
                }
            }
            catch (IOException e) {
                throw new DatasetIOException("Cannot find size of " + dir, e);
            }
        }
        return size;
    }

    @Override
    public long getLastModified() {
        long lastMod = -1L;
        Iterator<Path> i = this.dirIterator();
        while (i.hasNext()) {
            Path dir = i.next();
            try {
                for (FileStatus st : this.fileSystem.listStatus(dir)) {
                    if (lastMod >= st.getModificationTime()) continue;
                    lastMod = st.getModificationTime();
                }
            }
            catch (IOException e) {
                throw new DatasetIOException("Cannot find last modified time of of " + dir, e);
            }
        }
        return lastMod;
    }

    @Override
    public boolean isEmpty() {
        return this.unbounded.isEmpty();
    }

    public static class Builder<E> {
        private Configuration conf;
        private FileSystem fileSystem;
        private Path directory;
        private String namespace;
        private String name;
        private DatasetDescriptor descriptor;
        private Class<E> type;
        private URI uri;
        private PartitionKey partitionKey;
        private PartitionListener partitionListener;

        public Builder<E> namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder<E> name(String name) {
            this.name = name;
            return this;
        }

        protected Builder<E> fileSystem(FileSystem fs) {
            this.fileSystem = fs;
            return this;
        }

        public Builder<E> configuration(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder<E> descriptor(DatasetDescriptor descriptor) {
            Preconditions.checkArgument((descriptor.getLocation() != null ? 1 : 0) != 0, (Object)"Dataset location cannot be null");
            this.descriptor = descriptor;
            return this;
        }

        public Builder<E> type(Class<E> type) {
            Preconditions.checkNotNull(type, (Object)"Type cannot be null");
            this.type = type;
            return this;
        }

        public Builder<E> uri(URI uri) {
            this.uri = uri;
            return this;
        }

        Builder<E> partitionKey(@Nullable PartitionKey partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        Builder<E> partitionListener(@Nullable PartitionListener partitionListener) {
            this.partitionListener = partitionListener;
            return this;
        }

        public FileSystemDataset<E> build() {
            Preconditions.checkState((this.namespace != null ? 1 : 0) != 0, (Object)"No namespace defined");
            Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"No dataset name defined");
            Preconditions.checkState((this.descriptor != null ? 1 : 0) != 0, (Object)"No dataset descriptor defined");
            Preconditions.checkState((this.conf != null || this.fileSystem != null ? 1 : 0) != 0, (Object)"Configuration or FileSystem must be set");
            Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"No type specified");
            this.directory = new Path(this.descriptor.getLocation());
            if (this.fileSystem == null) {
                try {
                    this.fileSystem = this.directory.getFileSystem(this.conf);
                }
                catch (IOException ex) {
                    throw new DatasetIOException("Cannot access FileSystem", ex);
                }
            }
            Path absoluteDirectory = this.fileSystem.makeQualified(this.directory);
            return new FileSystemDataset<E>(this.fileSystem, absoluteDirectory, this.namespace, this.name, this.descriptor, this.uri, this.partitionKey, this.partitionListener, this.type);
        }
    }
}

