/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.DatasetNotFoundException;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.URIBuilder;
import org.kitesdk.data.spi.AbstractDatasetRepository;
import org.kitesdk.data.spi.Compatibility;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.MetadataProvider;
import org.kitesdk.data.spi.PartitionKey;
import org.kitesdk.data.spi.PartitionListener;
import org.kitesdk.data.spi.TemporaryDatasetRepository;
import org.kitesdk.data.spi.TemporaryDatasetRepositoryAccessor;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.kitesdk.data.spi.filesystem.FileSystemMetadataProvider;
import org.kitesdk.data.spi.filesystem.FileSystemUtil;
import org.kitesdk.data.spi.filesystem.PathConversion;
import org.kitesdk.data.spi.filesystem.TemporaryFileSystemDatasetRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemDatasetRepository
extends AbstractDatasetRepository
implements TemporaryDatasetRepositoryAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemDatasetRepository.class);
    private final MetadataProvider metadataProvider;
    private final Configuration conf;
    private final FileSystem fs;
    private final Path rootDirectory;
    private final URI repositoryUri;

    public FileSystemDatasetRepository(Configuration conf, Path rootDirectory) {
        this(conf, rootDirectory, new FileSystemMetadataProvider(conf, rootDirectory));
    }

    public FileSystemDatasetRepository(Configuration conf, Path rootDirectory, MetadataProvider provider) {
        Preconditions.checkNotNull((Object)conf, (Object)"Configuration cannot be null");
        Preconditions.checkNotNull((Object)rootDirectory, (Object)"Root directory cannot be null");
        Preconditions.checkNotNull((Object)provider, (Object)"Metadata provider cannot be null");
        try {
            this.fs = rootDirectory.getFileSystem(conf);
        }
        catch (IOException e) {
            throw new DatasetIOException("Cannot get FileSystem for repository location: " + rootDirectory, e);
        }
        this.conf = conf;
        this.rootDirectory = this.fs.makeQualified(rootDirectory);
        this.repositoryUri = URI.create("repo:" + this.rootDirectory.toUri());
        this.metadataProvider = provider;
    }

    @Override
    public <E> Dataset<E> create(String namespace, String name, DatasetDescriptor descriptor, Class<E> type) {
        Preconditions.checkNotNull((Object)namespace, (Object)"Namespace cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Dataset name cannot be null");
        Preconditions.checkNotNull((Object)descriptor, (Object)"Descriptor cannot be null");
        Path suggestedLocation = this.pathForDataset(namespace, name);
        DatasetDescriptor newDescriptor = descriptor;
        if (descriptor.getLocation() == null) {
            newDescriptor = new DatasetDescriptor.Builder(descriptor).location(suggestedLocation).build();
        }
        newDescriptor = this.metadataProvider.create(namespace, name, newDescriptor);
        FileSystemUtil.ensureLocationExists(newDescriptor, this.conf);
        LOG.debug("Created dataset: {} schema: {} datasetPath: {}", new Object[]{name, newDescriptor.getSchema(), newDescriptor.getLocation()});
        return new FileSystemDataset.Builder().namespace(namespace).name(name).configuration(this.conf).descriptor(newDescriptor).type(type).uri(new URIBuilder(this.getUri(), namespace, name).build()).partitionKey(newDescriptor.isPartitioned() ? new PartitionKey(new Object[0]) : null).partitionListener(this.getPartitionListener()).build();
    }

    @Override
    public <E> Dataset<E> update(String namespace, String name, DatasetDescriptor descriptor, Class<E> type) {
        Preconditions.checkNotNull((Object)namespace, (Object)"Namespace cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Dataset name cannot be null");
        Preconditions.checkNotNull((Object)descriptor, (Object)"Descriptor cannot be null");
        DatasetDescriptor oldDescriptor = this.metadataProvider.load(namespace, name);
        Compatibility.checkUpdate(oldDescriptor, descriptor);
        DatasetDescriptor updatedDescriptor = this.metadataProvider.update(namespace, name, descriptor);
        LOG.debug("Updated dataset: {} schema: {} location: {}", new Object[]{name, updatedDescriptor.getSchema(), updatedDescriptor.getLocation()});
        return new FileSystemDataset.Builder().namespace(namespace).name(name).configuration(this.conf).descriptor(updatedDescriptor).type(type).uri(new URIBuilder(this.getUri(), namespace, name).build()).partitionKey(updatedDescriptor.isPartitioned() ? new PartitionKey(new Object[0]) : null).partitionListener(this.getPartitionListener()).build();
    }

    @Override
    public <E> Dataset<E> load(String namespace, String name, Class<E> type) {
        Preconditions.checkNotNull((Object)namespace, (Object)"Namespace cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Dataset name cannot be null");
        LOG.debug("Loading dataset: {}", (Object)name);
        DatasetDescriptor descriptor = this.metadataProvider.load(namespace, name);
        FileSystemDataset ds = new FileSystemDataset.Builder().namespace(namespace).name(name).configuration(this.conf).descriptor(descriptor).type(type).uri(new URIBuilder(this.getUri(), namespace, name).build()).partitionKey(descriptor.isPartitioned() ? new PartitionKey(new Object[0]) : null).partitionListener(this.getPartitionListener()).build();
        LOG.debug("Loaded dataset:{}", ds);
        return ds;
    }

    @Override
    public boolean delete(String namespace, String name) {
        boolean changed;
        block7: {
            DatasetDescriptor descriptor;
            Preconditions.checkNotNull((Object)namespace, (Object)"Namespace cannot be null");
            Preconditions.checkNotNull((Object)name, (Object)"Dataset name cannot be null");
            LOG.debug("Deleting dataset:{}", (Object)name);
            try {
                descriptor = this.metadataProvider.load(namespace, name);
            }
            catch (DatasetNotFoundException ex) {
                return false;
            }
            changed = this.metadataProvider.delete(namespace, name);
            Path dataLocation = new Path(descriptor.getLocation());
            FileSystem dataFS = FileSystemDatasetRepository.fsForPath(dataLocation, this.conf);
            if (this.fs.getUri().equals(dataFS.getUri())) {
                changed |= FileSystemUtil.cleanlyDelete(this.fs, this.rootDirectory, dataLocation);
            } else {
                try {
                    if (!dataFS.exists(dataLocation)) break block7;
                    if (dataFS.delete(dataLocation, true)) {
                        changed = true;
                        break block7;
                    }
                    throw new IOException("Failed to delete dataset name:" + name + " location:" + dataLocation);
                }
                catch (IOException e) {
                    throw new DatasetIOException("Internal failure when removing location:" + dataLocation, e);
                }
            }
        }
        return changed;
    }

    @Override
    public boolean exists(String namespace, String name) {
        Preconditions.checkNotNull((Object)namespace, (Object)"Namespace cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Dataset name cannot be null");
        return this.metadataProvider.exists(namespace, name);
    }

    @Override
    public Collection<String> datasets(String namespace) {
        return this.metadataProvider.datasets(namespace);
    }

    @Override
    public Collection<String> namespaces() {
        return this.metadataProvider.namespaces();
    }

    @Override
    public URI getUri() {
        return this.repositoryUri;
    }

    @Override
    public TemporaryDatasetRepository getTemporaryRepository(String namespace, String key) {
        return new TemporaryFileSystemDatasetRepository(this.conf, this.rootDirectory, namespace, key);
    }

    private Path pathForDataset(String namespace, String name) {
        return this.fs.makeQualified(FileSystemDatasetRepository.pathForDataset(this.rootDirectory, namespace, name));
    }

    @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="Checked in precondition")
    static Path pathForDataset(Path root, @Nullable String namespace, @Nullable String name) {
        Preconditions.checkNotNull((Object)namespace, (Object)"Namespace cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Dataset name cannot be null");
        return new Path(root, new Path(namespace, name.replace('.', '/')));
    }

    public static PartitionKey partitionKeyForPath(Dataset dataset, URI partitionPath) {
        Preconditions.checkState((boolean)dataset.getDescriptor().isPartitioned(), (String)"Attempt to get a partition on a non-partitioned dataset (name:%s)", (Object[])new Object[]{dataset.getName()});
        Preconditions.checkArgument((boolean)(dataset instanceof FileSystemDataset), (Object)"Dataset is not a FileSystemDataset");
        FileSystemDataset fsDataset = (FileSystemDataset)dataset;
        FileSystem fs = fsDataset.getFileSystem();
        URI partitionUri = fs.makeQualified(new Path(partitionPath)).toUri();
        URI directoryUri = fsDataset.getDirectory().toUri();
        URI relativizedUri = directoryUri.relativize(partitionUri);
        if (relativizedUri.equals(partitionUri)) {
            throw new IllegalArgumentException(String.format("Partition URI %s has different root directory to dataset (directory: %s).", partitionUri, directoryUri));
        }
        Iterable parts = Splitter.on((char)'/').split((CharSequence)relativizedUri.getPath());
        PartitionStrategy partitionStrategy = dataset.getDescriptor().getPartitionStrategy();
        List<FieldPartitioner> fieldPartitioners = partitionStrategy.getFieldPartitioners();
        if (Iterables.size((Iterable)parts) > fieldPartitioners.size()) {
            throw new IllegalArgumentException(String.format("Too many partition directories for %s (%s), expecting %s.", partitionUri, Iterables.size((Iterable)parts), fieldPartitioners.size()));
        }
        Schema schema = dataset.getDescriptor().getSchema();
        ArrayList values = Lists.newArrayList();
        int i = 0;
        for (String part : parts) {
            FieldPartitioner fp;
            Iterator split = Splitter.on((char)'=').split((CharSequence)part).iterator();
            String fieldName = (String)split.next();
            if (!fieldName.equals((fp = fieldPartitioners.get(i++)).getName())) {
                throw new IllegalArgumentException(String.format("Unrecognized partition name '%s' in partition %s, expecting '%s'.", fieldName, partitionUri, fp.getName()));
            }
            if (!split.hasNext()) {
                throw new IllegalArgumentException(String.format("Missing partition value for '%s' in partition %s.", fieldName, partitionUri));
            }
            String stringValue = (String)split.next();
            values.add(PathConversion.valueForDirname(fp, schema, stringValue));
        }
        return new PartitionKey(values.toArray(new Object[values.size()]));
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("fs", (Object)this.fs).add("storage", (Object)this.rootDirectory).add("metadataProvider", (Object)this.metadataProvider).toString();
    }

    MetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    private PartitionListener getPartitionListener() {
        return this.metadataProvider instanceof PartitionListener ? (PartitionListener)((Object)this.metadataProvider) : null;
    }

    private static FileSystem fsForPath(Path dataPath, Configuration conf) {
        try {
            return dataPath.getFileSystem(conf);
        }
        catch (IOException ex) {
            throw new DatasetIOException("Cannot get FileSystem for descriptor", ex);
        }
    }

    public static class Builder {
        private Path rootDirectory;
        private FileSystem fileSystem;
        private Configuration configuration;

        public Builder rootDirectory(Path path) {
            this.rootDirectory = path;
            return this;
        }

        public Builder rootDirectory(URI uri) {
            this.rootDirectory = new Path(uri);
            return this;
        }

        public Builder rootDirectory(String uri) throws URISyntaxException {
            return this.rootDirectory(new URI(uri));
        }

        public Builder fileSystem(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        public Builder configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public FileSystemDatasetRepository build() {
            if (this.configuration == null) {
                this.configuration = new Configuration();
            }
            Preconditions.checkState((this.rootDirectory != null ? 1 : 0) != 0, (Object)"No root directory defined");
            if (this.fileSystem != null) {
                this.rootDirectory = this.fileSystem.makeQualified(this.rootDirectory);
            }
            return new FileSystemDatasetRepository(this.configuration, this.rootDirectory);
        }
    }
}

