/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.Format;
import org.kitesdk.data.Formats;
import org.kitesdk.data.UnknownFormatException;
import org.kitesdk.data.spi.AbstractDatasetReader;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.EntityAccessor;
import org.kitesdk.data.spi.ReaderWriterState;
import org.kitesdk.data.spi.filesystem.CSVFileReader;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetReader;
import org.kitesdk.data.spi.filesystem.ParquetFileSystemDatasetReader;
import org.kitesdk.data.spi.filesystem.PathIterator;

class MultiFileDatasetReader<E>
extends AbstractDatasetReader<E> {
    private final FileSystem fileSystem;
    private final DatasetDescriptor descriptor;
    private final Constraints constraints;
    private final EntityAccessor<E> accessor;
    private final Iterator<Path> filesIter;
    private final PathIterator pathIter;
    private AbstractDatasetReader<E> reader = null;
    private Iterator<E> readerIterator = null;
    private ReaderWriterState state;

    public MultiFileDatasetReader(FileSystem fileSystem, Iterable<Path> files, DatasetDescriptor descriptor, Constraints constraints, EntityAccessor<E> accessor) {
        Preconditions.checkNotNull((Object)fileSystem, (Object)"FileSystem cannot be null");
        Preconditions.checkNotNull((Object)descriptor, (Object)"Descriptor cannot be null");
        Preconditions.checkNotNull(files, (Object)"Partition paths cannot be null");
        this.fileSystem = fileSystem;
        this.descriptor = descriptor;
        this.constraints = constraints;
        this.filesIter = files.iterator();
        this.state = ReaderWriterState.NEW;
        this.pathIter = files instanceof PathIterator ? (PathIterator)files : null;
        this.accessor = accessor;
    }

    @Override
    public void initialize() {
        Preconditions.checkState((boolean)this.state.equals((Object)ReaderWriterState.NEW), (String)"A reader may not be opened more than once - current state:%s", (Object[])new Object[]{this.state});
        Format format = this.descriptor.getFormat();
        if (!(Formats.AVRO.equals(format) || Formats.PARQUET.equals(format) || Formats.CSV.equals(format))) {
            throw new UnknownFormatException("Cannot open format:" + format.getName());
        }
        this.state = ReaderWriterState.OPEN;
    }

    private void openNextReader() {
        this.reader = Formats.PARQUET.equals(this.descriptor.getFormat()) ? new ParquetFileSystemDatasetReader<E>(this.fileSystem, this.filesIter.next(), this.accessor.getEntitySchema(), this.accessor.getType()) : (Formats.CSV.equals(this.descriptor.getFormat()) ? new CSVFileReader<E>(this.fileSystem, this.filesIter.next(), this.descriptor, this.accessor) : new FileSystemDatasetReader<E>(this.fileSystem, this.filesIter.next(), this.accessor.getEntitySchema(), this.accessor.getType()));
        this.reader.initialize();
        this.readerIterator = Iterators.filter(this.reader, this.constraints.toEntityPredicate(this.pathIter != null ? this.pathIter.getStorageKey() : null, this.accessor));
    }

    @Override
    public boolean hasNext() {
        Preconditions.checkState((boolean)this.state.equals((Object)ReaderWriterState.OPEN), (String)"Attempt to read from a file in state:%s", (Object[])new Object[]{this.state});
        while (true) {
            if (this.readerIterator == null) {
                if (this.filesIter.hasNext()) {
                    this.openNextReader();
                    continue;
                }
                return false;
            }
            if (this.readerIterator.hasNext()) {
                return true;
            }
            this.readerIterator = null;
            this.reader.close();
            this.reader = null;
        }
    }

    @Override
    public E next() {
        Preconditions.checkState((boolean)this.state.equals((Object)ReaderWriterState.OPEN), (String)"Attempt to read from a file in state:%s", (Object[])new Object[]{this.state});
        if (this.hasNext()) {
            return this.readerIterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        Preconditions.checkState((boolean)this.state.equals((Object)ReaderWriterState.OPEN), (String)"Attempt to remove from a file in state:%s", (Object[])new Object[]{this.state});
        if (this.readerIterator == null) {
            throw new IllegalStateException("Remove can only be called after next() returns a value and before calling hasNext()");
        }
        this.readerIterator.remove();
    }

    @Override
    public void close() {
        if (!this.state.equals((Object)ReaderWriterState.OPEN)) {
            return;
        }
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
            this.readerIterator = null;
        }
        this.state = ReaderWriterState.CLOSED;
    }

    @Override
    public boolean isOpen() {
        return this.state.equals((Object)ReaderWriterState.OPEN);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("fileSystem", (Object)this.fileSystem).add("descriptor", (Object)this.descriptor).add("filesIter", this.filesIter).add("reader", this.reader).add("state", (Object)this.state).toString();
    }
}

