/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.EOFException;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.DatasetReaderException;
import org.kitesdk.data.spi.AbstractDatasetReader;
import org.kitesdk.data.spi.ReaderWriterState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import parquet.avro.AvroParquetReader;

class ParquetFileSystemDatasetReader<E extends IndexedRecord>
extends AbstractDatasetReader<E> {
    private FileSystem fileSystem;
    private Path path;
    private Schema schema;
    private Class<E> type;
    private ReaderWriterState state;
    private AvroParquetReader<E> reader;
    private E next;
    private static final Logger LOG = LoggerFactory.getLogger(ParquetFileSystemDatasetReader.class);

    public ParquetFileSystemDatasetReader(FileSystem fileSystem, Path path, Schema schema, Class<E> type) {
        Preconditions.checkArgument((fileSystem != null ? 1 : 0) != 0, (Object)"FileSystem cannot be null");
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"Path cannot be null");
        Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"Schema cannot be null");
        Preconditions.checkArgument((IndexedRecord.class.isAssignableFrom(type) || type == Object.class ? 1 : 0) != 0, (Object)"The entity type must implement IndexedRecord");
        this.fileSystem = fileSystem;
        this.path = path;
        this.schema = schema;
        this.type = type;
        this.state = ReaderWriterState.NEW;
    }

    @Override
    public void initialize() {
        Preconditions.checkState((boolean)this.state.equals((Object)ReaderWriterState.NEW), (String)"A reader may not be opened more than once - current state:%s", (Object[])new Object[]{this.state});
        LOG.debug("Opening reader on path:{}", (Object)this.path);
        try {
            this.reader = new AvroParquetReader(this.fileSystem.getConf(), this.fileSystem.makeQualified(this.path));
        }
        catch (IOException e) {
            throw new DatasetReaderException("Unable to create reader path:" + this.path, e);
        }
        this.state = ReaderWriterState.OPEN;
    }

    @Override
    public boolean hasNext() {
        Preconditions.checkState((boolean)this.state.equals((Object)ReaderWriterState.OPEN), (String)"Attempt to read from a file in state:%s", (Object[])new Object[]{this.state});
        if (this.next == null) {
            try {
                this.next = (IndexedRecord)this.reader.read();
            }
            catch (EOFException e) {
                return false;
            }
            catch (IOException e) {
                throw new DatasetReaderException("Unable to read next record from: " + this.path, e);
            }
        }
        return this.next != null;
    }

    @Override
    public E next() {
        Preconditions.checkState((boolean)this.state.equals((Object)ReaderWriterState.OPEN), (String)"Attempt to read from a file in state:%s", (Object[])new Object[]{this.state});
        E current = this.next;
        this.next = null;
        return current;
    }

    @Override
    public void close() {
        if (!this.state.equals((Object)ReaderWriterState.OPEN)) {
            return;
        }
        LOG.debug("Closing reader on path:{}", (Object)this.path);
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new DatasetReaderException("Unable to close reader path:" + this.path, e);
        }
        this.state = ReaderWriterState.CLOSED;
    }

    @Override
    public boolean isOpen() {
        return this.state.equals((Object)ReaderWriterState.OPEN);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("fileSystem", (Object)this.fileSystem).add("path", (Object)this.path).add("schema", (Object)this.schema).add("state", (Object)this.state).add("reader", this.reader).toString();
    }
}

