/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.spi.Pair;
import org.kitesdk.data.spi.StorageKey;
import org.kitesdk.data.spi.filesystem.PathFilters;

public class PathIterator
implements Iterator<Path>,
Iterable<Path> {
    private final FileSystem fs;
    private final Path root;
    private final Iterator<Pair<StorageKey, Path>> directories;
    private StorageKey key = null;
    private Iterator<Path> files = null;

    public PathIterator(FileSystem fs, Path root, Iterator<Pair<StorageKey, Path>> directories) {
        Preconditions.checkArgument((directories != null ? 1 : 0) != 0, (Object)"Directories cannot be null");
        this.fs = fs;
        this.root = root;
        this.directories = directories;
    }

    @Override
    public boolean hasNext() {
        if (this.files != null && this.files.hasNext()) {
            return true;
        }
        return this.advance();
    }

    public StorageKey getStorageKey() {
        return this.key;
    }

    @Override
    public Path next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.files.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }

    private boolean advance() {
        while (this.directories.hasNext()) {
            Pair<StorageKey, Path> pair = this.directories.next();
            try {
                FileStatus[] stats = this.fs.listStatus(new Path(this.root, pair.second()), PathFilters.notHidden());
                this.key = pair.first();
                ArrayList nextFileSet = Lists.newArrayListWithCapacity((int)stats.length);
                for (FileStatus stat : stats) {
                    if (stat.isDir()) continue;
                    nextFileSet.add(stat.getPath());
                }
                if (nextFileSet.size() <= 0) continue;
                this.files = nextFileSet.iterator();
                return true;
            }
            catch (IOException ex) {
                throw new DatasetIOException("Cannot list files in " + pair.second(), ex);
            }
        }
        return false;
    }

    @Override
    public Iterator<Path> iterator() {
        return this;
    }
}

