/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.partition;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Calendar;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.data.spi.FieldPartitioner;

@SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE", "SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="False positive due to generics.")
@Immutable
public class CalendarFieldPartitioner
extends FieldPartitioner<Long, Integer> {
    protected static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    protected int calendarField;

    public CalendarFieldPartitioner(String sourceName, String name, int calendarField, int cardinality) {
        super(sourceName, name, Long.class, Integer.class, cardinality);
        this.calendarField = calendarField;
    }

    @Override
    public Integer apply(@Nonnull Long timestamp) {
        Calendar cal = Calendar.getInstance(UTC);
        cal.setTimeInMillis(timestamp);
        return cal.get(this.calendarField);
    }

    @Override
    public Predicate<Integer> project(Predicate<Long> predicate) {
        return null;
    }

    @Override
    public Predicate<Integer> projectStrict(Predicate<Long> predicate) {
        return null;
    }

    public int getCalendarField() {
        return this.calendarField;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CalendarFieldPartitioner that = (CalendarFieldPartitioner)o;
        return Objects.equal((Object)this.getSourceName(), (Object)that.getSourceName()) && Objects.equal((Object)this.getName(), (Object)that.getName()) && Objects.equal((Object)this.getCardinality(), (Object)that.getCardinality());
    }

    @Override
    public int compare(Integer o1, Integer o2) {
        return o1.compareTo(o2);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getSourceName(), this.getName(), this.getCardinality()});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("sourceName", (Object)this.getSourceName()).add("name", (Object)this.getName()).add("cardinality", this.getCardinality()).toString();
    }
}

