/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.partition;

import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.predicates.Exists;
import org.kitesdk.data.spi.predicates.In;
import org.kitesdk.data.spi.predicates.Predicates;
import org.kitesdk.data.spi.predicates.Range;
import org.kitesdk.data.spi.predicates.Ranges;

@SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE", "SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="False positive due to generics.")
@Immutable
public class DateFormatPartitioner
extends FieldPartitioner<Long, String> {
    private static final String DEFAULT_TIME_ZONE = "UTC";
    private final SimpleDateFormat format;

    public DateFormatPartitioner(String sourceName, String name, String format) {
        this(sourceName, name, format, 1095, TimeZone.getTimeZone(DEFAULT_TIME_ZONE));
    }

    public DateFormatPartitioner(String sourceName, String name, String format, int cardinality, TimeZone zone) {
        super(sourceName, name, Long.class, String.class, cardinality);
        Preconditions.checkArgument((boolean)CharMatcher.is((char)'/').matchesNoneOf((CharSequence)format), (Object)"Illegal format: \"/\" is not allowed (use multiple partition fields)");
        this.format = new SimpleDateFormat(format);
        this.format.setTimeZone(zone);
    }

    public String getPattern() {
        return this.format.toPattern();
    }

    @Override
    public String apply(Long value) {
        return this.format.format(new Date(value));
    }

    @Override
    public Predicate<String> project(Predicate<Long> predicate) {
        if (predicate instanceof Exists) {
            return Predicates.exists();
        }
        if (predicate instanceof In) {
            return ((In)predicate).transform(this);
        }
        if (predicate instanceof Range) {
            return Ranges.transformClosed((Range)predicate, this);
        }
        return null;
    }

    @Override
    public Predicate<String> projectStrict(Predicate<Long> predicate) {
        if (predicate instanceof Exists) {
            return Predicates.exists();
        }
        return null;
    }

    @Override
    public int compare(String o1, String o2) {
        return o1.compareTo(o2);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        DateFormatPartitioner that = (DateFormatPartitioner)o;
        return Objects.equal((Object)this.getSourceName(), (Object)that.getSourceName()) && Objects.equal((Object)this.getName(), (Object)that.getName()) && Objects.equal((Object)this.format, (Object)that.format) && Objects.equal((Object)this.getCardinality(), (Object)that.getCardinality());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getSourceName(), this.getName(), this.format, this.getCardinality()});
    }
}

