/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.partition;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.predicates.Exists;
import org.kitesdk.data.spi.predicates.In;
import org.kitesdk.data.spi.predicates.Predicates;

@SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE", "SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="False positive due to generics.")
@Immutable
public class HashFieldPartitioner
extends FieldPartitioner<Object, Integer> {
    public HashFieldPartitioner(String sourceName, int buckets) {
        this(sourceName, null, buckets);
    }

    public HashFieldPartitioner(String sourceName, @Nullable String name, int buckets) {
        super(sourceName, name == null ? sourceName + "_hash" : name, Object.class, Integer.class, buckets);
        Preconditions.checkArgument((buckets > 0 ? 1 : 0) != 0, (String)"Number of hash buckets is negative: %s", (Object[])new Object[]{buckets});
    }

    @Override
    public Integer apply(Object value) {
        return (value.hashCode() & Integer.MAX_VALUE) % this.getCardinality();
    }

    @Override
    public Predicate<Integer> project(Predicate<Object> predicate) {
        if (predicate instanceof Exists) {
            return Predicates.exists();
        }
        if (predicate instanceof In) {
            return ((In)predicate).transform(this);
        }
        return null;
    }

    @Override
    public Predicate<Integer> projectStrict(Predicate<Object> predicate) {
        return null;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        HashFieldPartitioner that = (HashFieldPartitioner)o;
        return Objects.equal((Object)this.getSourceName(), (Object)that.getSourceName()) && Objects.equal((Object)this.getName(), (Object)that.getName()) && Objects.equal((Object)this.getCardinality(), (Object)that.getCardinality());
    }

    @Override
    public int compare(Integer o1, Integer o2) {
        return o1.compareTo(o2);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getSourceName(), this.getName(), this.getCardinality()});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("sourceName", (Object)this.getSourceName()).add("name", (Object)this.getName()).add("cardinality", this.getCardinality()).toString();
    }
}

