/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.partition;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.predicates.Exists;
import org.kitesdk.data.spi.predicates.In;
import org.kitesdk.data.spi.predicates.Predicates;
import org.kitesdk.data.spi.predicates.Range;

@SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="Implement if we intend to use in Serializable objects  (e.g., TreeMaps) and use java serialization.")
@Immutable
public class ListFieldPartitioner<S>
extends FieldPartitioner<S, Integer> {
    private final List<Set<S>> values;

    public ListFieldPartitioner(String sourceName, List<Set<S>> values, Class<S> sourceType) {
        this(sourceName, null, values, sourceType);
    }

    public ListFieldPartitioner(String sourceName, @Nullable String name, List<Set<S>> values, Class<S> sourceType) {
        super(sourceName, name == null ? sourceName + "_set" : name, sourceType, Integer.class, ListFieldPartitioner.cardinality(values));
        this.values = values;
    }

    private static <S> int cardinality(List<Set<S>> values) {
        return values.size();
    }

    @Override
    public Integer apply(S value) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (!this.values.get(i).contains(value)) continue;
            return i;
        }
        throw new IllegalArgumentException(value + " is not in set");
    }

    @Override
    public Predicate<Integer> project(Predicate<S> predicate) {
        if (predicate instanceof Exists) {
            return Predicates.exists();
        }
        if (predicate instanceof In) {
            return ((In)predicate).transform(this);
        }
        if (predicate instanceof Range) {
            Range range = (Range)predicate;
            HashSet possibleValues = Sets.newHashSet();
            block0: for (int i = 0; i < this.values.size(); ++i) {
                Set<S> items = this.values.get(i);
                if (items.size() == Integer.MAX_VALUE) {
                    possibleValues.add(i);
                    continue;
                }
                for (S item : items) {
                    if (!range.contains(item)) continue;
                    possibleValues.add(i);
                    continue block0;
                }
            }
            if (!possibleValues.isEmpty()) {
                return Predicates.in(possibleValues);
            }
        }
        return null;
    }

    @Override
    public Predicate<Integer> projectStrict(Predicate<S> predicate) {
        if (predicate instanceof Exists) {
            return Predicates.exists();
        }
        if (predicate instanceof In || predicate instanceof Range) {
            HashSet possibleValues = Sets.newHashSet();
            for (int i = 0; i < this.values.size(); ++i) {
                Set<S> items = this.values.get(i);
                if (items.size() == Integer.MAX_VALUE) continue;
                boolean matchedAll = true;
                for (S entry : items) {
                    matchedAll = matchedAll && predicate.apply(entry);
                }
                if (!matchedAll) continue;
                possibleValues.add(i);
            }
            if (!possibleValues.isEmpty()) {
                return Predicates.in(possibleValues);
            }
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        ListFieldPartitioner that = (ListFieldPartitioner)o;
        return Objects.equal((Object)this.getName(), (Object)that.getName()) && Objects.equal(this.values, that.values);
    }

    @Override
    public int compare(Integer o1, Integer o2) {
        return o1.compareTo(o2);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getName(), this.values});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("values", this.values).toString();
    }
}

