/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.partition;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.DiscreteDomains;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.predicates.Exists;
import org.kitesdk.data.spi.predicates.In;
import org.kitesdk.data.spi.predicates.Predicates;
import org.kitesdk.data.spi.predicates.Range;
import org.kitesdk.data.spi.predicates.Ranges;

@SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE", "SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="False positive due to generics.")
@Immutable
public class RangeFieldPartitioner
extends FieldPartitioner<String, String> {
    private final List<String> upperBounds;
    private RangeDomain domain;

    public RangeFieldPartitioner(String sourceName, String ... upperBounds) {
        this(sourceName, (String)null, upperBounds);
    }

    public RangeFieldPartitioner(String sourceName, @Nullable String name, String ... upperBounds) {
        super(sourceName, name == null ? sourceName + "_bound" : name, String.class, String.class, upperBounds.length);
        this.upperBounds = Arrays.asList(upperBounds);
    }

    @Override
    public String apply(String value) {
        for (String upper : this.upperBounds) {
            if (value.compareTo(upper) > 0) continue;
            return upper;
        }
        throw new IllegalArgumentException(value + " is outside bounds");
    }

    @Override
    public Predicate<String> project(Predicate<String> predicate) {
        if (predicate instanceof Exists) {
            return Predicates.exists();
        }
        if (predicate instanceof In) {
            return ((In)predicate).transform(this);
        }
        if (predicate instanceof Range) {
            Range<String> transformed = Ranges.transformClosed((Range)predicate, this);
            return Predicates.in(Ranges.asSet(transformed, this.domain()));
        }
        return null;
    }

    @Override
    public Predicate<String> projectStrict(Predicate<String> predicate) {
        Range<String> transformed;
        if (predicate instanceof Exists) {
            return Predicates.exists();
        }
        if (predicate instanceof In) {
            return null;
        }
        if (predicate instanceof Range && (transformed = this.transformClosed((Range)predicate)) != null) {
            return Predicates.in(Ranges.asSet(transformed, this.domain()));
        }
        return null;
    }

    public List<String> getUpperBounds() {
        return this.upperBounds;
    }

    private RangeDomain domain() {
        if (this.domain == null) {
            this.domain = new RangeDomain();
        }
        return this.domain;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        RangeFieldPartitioner that = (RangeFieldPartitioner)o;
        return Objects.equal((Object)this.getName(), (Object)that.getName()) && Objects.equal(this.upperBounds, that.upperBounds);
    }

    @Override
    public int compare(String o1, String o2) {
        return this.apply(o1).compareTo(this.apply(o2));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getName(), this.upperBounds});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("upperBounds", this.upperBounds).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Range<String> transformClosed(Range<String> range) {
        String upperImage;
        if (range.hasLowerBound()) {
            String upperImage2;
            String lower = range.lowerEndpoint();
            String afterLower = this.domain().next(this.apply(lower));
            if (afterLower == null) return null;
            if (!range.hasUpperBound()) return Ranges.atLeast(afterLower);
            String upper = range.upperEndpoint();
            if (upper.equals(upperImage2 = this.apply(upper)) && range.isUpperBoundClosed()) {
                return Ranges.closed(afterLower, upperImage2);
            }
            String beforeUpper = this.domain().previous(upperImage2);
            if (afterLower.compareTo(beforeUpper) > 0) return null;
            return Ranges.closed(afterLower, beforeUpper);
        }
        if (!range.hasUpperBound()) return null;
        String upper = range.upperEndpoint();
        if (upper.equals(upperImage = this.apply(upper)) && range.isUpperBoundClosed()) {
            return Ranges.atMost(upperImage);
        }
        String beforeUpper = this.domain().previous(upperImage);
        if (beforeUpper == null) return null;
        return Ranges.atMost(beforeUpper);
    }

    private class RangeDomain
    extends DiscreteDomain<String> {
        private RangeDomain() {
        }

        public String next(String value) {
            int nextIndex = RangeFieldPartitioner.this.upperBounds.indexOf(RangeFieldPartitioner.this.apply(value)) + 1;
            return nextIndex == RangeFieldPartitioner.this.upperBounds.size() ? null : (String)RangeFieldPartitioner.this.upperBounds.get(nextIndex);
        }

        public String previous(String value) {
            int index = RangeFieldPartitioner.this.upperBounds.indexOf(RangeFieldPartitioner.this.apply(value));
            return index == 0 ? null : (String)RangeFieldPartitioner.this.upperBounds.get(index - 1);
        }

        public long distance(String start, String end) {
            return RangeFieldPartitioner.this.upperBounds.indexOf(RangeFieldPartitioner.this.apply(end)) - RangeFieldPartitioner.this.upperBounds.indexOf(RangeFieldPartitioner.this.apply(start));
        }

        public String minValue() {
            return (String)RangeFieldPartitioner.this.upperBounds.get(0);
        }

        public String maxValue() {
            DiscreteDomains.integers();
            return (String)RangeFieldPartitioner.this.upperBounds.get(RangeFieldPartitioner.this.upperBounds.size() - 1);
        }
    }
}

