/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.predicates;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.kitesdk.data.spi.SchemaUtil;
import org.kitesdk.data.spi.predicates.Predicates;
import org.kitesdk.data.spi.predicates.RegisteredPredicate;

public class In<T>
extends RegisteredPredicate<T> {
    private static final String IN = "in";
    private final Set<T> set;

    public static <T> In<T> fromString(String set, Schema schema) {
        HashSet values = Sets.newHashSet();
        for (String value : Splitter.on((char)',').split((CharSequence)set)) {
            values.add(SchemaUtil.fromString(value, schema));
        }
        return Predicates.in(values);
    }

    In(Iterable<T> values) {
        this.set = ImmutableSet.copyOf(values);
        Preconditions.checkArgument((this.set.size() > 0 ? 1 : 0) != 0, (Object)"No values to match");
    }

    In(T ... values) {
        this.set = ImmutableSet.copyOf((Object[])values);
    }

    In(Set<T> set) {
        this.set = set;
    }

    @Override
    public String getName() {
        return IN;
    }

    public boolean apply(@Nullable T test) {
        return test != null && this.set.contains(test);
    }

    public In<T> filter(Predicate<? super T> predicate) {
        try {
            return new In<T>(Iterables.filter(this.set, predicate));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Filter predicate produces empty set", e);
        }
    }

    public <V> In<V> transform(Function<? super T, V> function) {
        return new In<T>(Iterables.transform(this.set, function));
    }

    Set<T> getSet() {
        return this.set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equal(this.set, ((In)o).set);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.set});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("set", this.set).toString();
    }

    @Override
    public String toString(Schema schema) {
        return Joiner.on((char)',').join(Iterables.transform(this.set, new ToString(schema)));
    }

    static {
        RegisteredPredicate.register(IN, new RegisteredPredicate.Factory(){

            public <V> RegisteredPredicate<V> fromString(String values, Schema schema) {
                return In.fromString(values, schema);
            }
        });
    }

    private static class ToString<T>
    implements Function<T, String> {
        private final Schema schema;

        private ToString(Schema schema) {
            this.schema = schema;
        }

        public String apply(@Nullable T input) {
            return SchemaUtil.toString(input, this.schema);
        }
    }
}

