/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import org.apache.flume.Context;
import org.apache.flume.FlumeException;
import org.apache.flume.Sink;
import org.apache.flume.SinkProcessor;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.conf.Configurables;
import org.apache.flume.conf.sink.SinkProcessorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkProcessorFactory {
    private static final Logger logger = LoggerFactory.getLogger(SinkProcessorFactory.class);
    private static final String TYPE = "type";

    public static SinkProcessor getProcessor(Context context, List<Sink> sinks) {
        SinkProcessor processor;
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull(sinks);
        Preconditions.checkArgument((!sinks.isEmpty() ? 1 : 0) != 0);
        ImmutableMap params = context.getParameters();
        String typeStr = (String)params.get(TYPE);
        SinkProcessorType type = SinkProcessorType.OTHER;
        String processorClassName = typeStr;
        try {
            type = SinkProcessorType.valueOf((String)typeStr.toUpperCase());
        }
        catch (Exception ex) {
            logger.warn("Sink Processor type {} is a custom type", (Object)typeStr);
        }
        if (!type.equals((Object)SinkProcessorType.OTHER)) {
            processorClassName = type.getSinkProcessorClassName();
        }
        logger.debug("Creating instance of sink processor type {}, class {}", (Object)typeStr, (Object)processorClassName);
        Class<?> processorClass = null;
        try {
            processorClass = Class.forName(processorClassName);
        }
        catch (Exception ex) {
            throw new FlumeException("Unable to load sink processor type: " + typeStr + ", class: " + type.getSinkProcessorClassName(), (Throwable)ex);
        }
        try {
            processor = (SinkProcessor)processorClass.newInstance();
        }
        catch (Exception e) {
            throw new FlumeException("Unable to create sink processor, type: " + typeStr + ", class: " + processorClassName, (Throwable)e);
        }
        processor.setSinks(sinks);
        Configurables.configure((Object)processor, context);
        return processor;
    }

    public static SinkProcessor getProcessor(ComponentConfiguration conf, List<Sink> sinks) {
        SinkProcessor processor;
        String typeStr = conf.getType();
        SinkProcessorType type = SinkProcessorType.DEFAULT;
        try {
            type = SinkProcessorType.valueOf((String)typeStr.toUpperCase());
        }
        catch (Exception ex) {
            logger.warn("Sink type {} does not exist, using default", (Object)typeStr);
        }
        Class<?> processorClass = null;
        try {
            processorClass = Class.forName(type.getSinkProcessorClassName());
        }
        catch (Exception ex) {
            throw new FlumeException("Unable to load sink processor type: " + typeStr + ", class: " + type.getSinkProcessorClassName(), (Throwable)ex);
        }
        try {
            processor = (SinkProcessor)processorClass.newInstance();
        }
        catch (Exception e) {
            throw new FlumeException("Unable to create processor, type: " + typeStr + ", class: " + type.getSinkProcessorClassName(), (Throwable)e);
        }
        processor.setSinks(sinks);
        Configurables.configure((Object)processor, conf);
        return processor;
    }
}

