/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.minicluster.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.PropertyConfigurator;
import org.kitesdk.minicluster.MiniCluster;
import org.kitesdk.minicluster.cli.Command;
import org.kitesdk.minicluster.cli.Help;
import org.kitesdk.minicluster.cli.RunCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandDescription="Kite minicluster utility")
public class Main
extends Configured
implements Tool {
    public static final String PROGRAM_NAME = "minicluster";
    private static Set<String> HELP_ARGS = ImmutableSet.of((Object)"-h", (Object)"-help", (Object)"--help", (Object)"help");
    private final Logger console;
    private final Help help;
    private final JCommander jc;

    Main(Logger console) {
        this.console = console;
        this.jc = new JCommander((Object)this);
        this.help = new Help(this.jc, console);
        this.jc.setProgramName(PROGRAM_NAME);
        this.jc.addCommand("help", (Object)this.help, new String[]{"-h", "-help", "--help"});
        this.jc.addCommand("run", (Object)new RunCommand(console, this.getConf()));
    }

    public int run(String[] args) throws Exception {
        try {
            this.jc.parse(args);
        }
        catch (MissingCommandException e) {
            this.console.error(e.getMessage());
            return 1;
        }
        catch (ParameterException e) {
            String cmd = this.jc.getParsedCommand();
            if (args.length == 1) {
                this.help.helpCommands.add(cmd);
                this.help.run();
                return 1;
            }
            for (String arg : args) {
                if (!HELP_ARGS.contains(arg)) continue;
                this.help.helpCommands.add(cmd);
                this.help.run();
                return 0;
            }
            this.console.error(e.getMessage());
            return 1;
        }
        String parsed = this.jc.getParsedCommand();
        if (parsed == null) {
            this.help.run();
            return 1;
        }
        if ("help".equals(parsed)) {
            return this.help.run();
        }
        Command command = (Command)((JCommander)this.jc.getCommands().get(parsed)).getObjects().get(0);
        if (command == null) {
            this.help.run();
            return 1;
        }
        try {
            return command.run();
        }
        catch (IllegalArgumentException e) {
            this.console.error("Argument error: {}", (Object)e.getMessage());
            return 1;
        }
        catch (IllegalStateException e) {
            this.console.error("State error: {}", (Object)e.getMessage());
            return 1;
        }
        catch (Exception e) {
            this.console.error("Unknown error: {}", (Object)e.getMessage());
            this.console.error("ERROR", (Throwable)e);
            return 1;
        }
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((URL)MiniCluster.class.getResource("/kite-minicluster-logging.properties"));
        Logger console = LoggerFactory.getLogger(MiniCluster.class);
        int rc = ToolRunner.run((Configuration)new Configuration(), (Tool)new Main(console), (String[])args);
        System.exit(rc);
    }
}

