/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import java.io.Serializable;
import java.util.Comparator;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.data.spi.Marker;
import org.kitesdk.data.spi.MarkerComparator;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.collect.Ordering;
import parquet.Preconditions;

@Immutable
public class MarkerRange {
    private final MarkerComparator comparator;
    private final Boundary start;
    private final Boundary end;

    private MarkerRange() {
        this.comparator = null;
        this.start = Boundary.NEGATIVE_INFINITY;
        this.end = Boundary.POSITIVE_INFINITY;
    }

    public MarkerRange(MarkerComparator comparator) {
        org.kitesdk.shaded.com.google.common.base.Preconditions.checkArgument(comparator != null, "Comparator cannot be null.");
        this.comparator = comparator;
        this.start = Boundary.NEGATIVE_INFINITY;
        this.end = Boundary.POSITIVE_INFINITY;
    }

    private MarkerRange(MarkerComparator comparator, Boundary start, Boundary end) {
        block3: {
            try {
                if (start.compareTo(end) > 0) {
                    throw new IllegalArgumentException("Invalid range: " + start + ", " + end);
                }
            }
            catch (IllegalStateException e) {
                if ((!comparator.contains(start.bound, end.bound) || start.isInclusive) && (!comparator.contains(end.bound, start.bound) || end.isInclusive)) break block3;
                throw new IllegalArgumentException("Invalid range: " + start + ", " + end);
            }
        }
        this.comparator = comparator;
        this.start = start;
        this.end = end;
    }

    public boolean contains(Marker marker) {
        return this.start.isLessThan(marker) && this.end.isGreaterThan(marker);
    }

    public MarkerRange from(Marker start) {
        org.kitesdk.shaded.com.google.common.base.Preconditions.checkArgument(this.contains(start), "Start boundary is outside of this range");
        return new MarkerRange(this.comparator, new Boundary(this.comparator, start, true), this.end);
    }

    public MarkerRange fromAfter(Marker start) {
        org.kitesdk.shaded.com.google.common.base.Preconditions.checkArgument(this.contains(start), "Start boundary is outside of this range");
        return new MarkerRange(this.comparator, new Boundary(this.comparator, start, false), this.end);
    }

    public MarkerRange to(Marker end) {
        org.kitesdk.shaded.com.google.common.base.Preconditions.checkArgument(this.contains(end), "End boundary is outside of this range");
        return new MarkerRange(this.comparator, this.start, new Boundary(this.comparator, end, true));
    }

    public MarkerRange toBefore(Marker end) {
        org.kitesdk.shaded.com.google.common.base.Preconditions.checkArgument(this.contains(end), "End boundary is outside of this range");
        return new MarkerRange(this.comparator, this.start, new Boundary(this.comparator, end, false));
    }

    public MarkerRange of(Marker partial) {
        org.kitesdk.shaded.com.google.common.base.Preconditions.checkArgument(this.contains(partial), "Marker is outside of this range");
        return new MarkerRange(this.comparator, new Boundary(this.comparator, partial, true), new Boundary(this.comparator, partial, true));
    }

    public MarkerRange intersection(MarkerRange other) {
        Boundary newStart = Ordering.from(new Boundary.LeftComparator()).max(this.start, other.start);
        Boundary newEnd = Ordering.from(new Boundary.RightComparator()).min(this.end, other.end);
        return new MarkerRange(this.comparator, newStart, newEnd);
    }

    public MarkerRange span(MarkerRange other) {
        Boundary newStart = Ordering.from(new Boundary.LeftComparator()).min(this.start, other.start);
        Boundary newEnd = Ordering.from(new Boundary.RightComparator()).max(this.end, other.end);
        return new MarkerRange(this.comparator, newStart, newEnd);
    }

    public MarkerRange complement() {
        if (this.start == Boundary.NEGATIVE_INFINITY && this.end == Boundary.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("Cannot find complement of unbounded range.");
        }
        if (this.start == Boundary.NEGATIVE_INFINITY) {
            Boundary newStart = new Boundary(this.comparator, this.end.bound, !this.end.isInclusive);
            Boundary newEnd = Boundary.POSITIVE_INFINITY;
            return new MarkerRange(this.comparator, newStart, newEnd);
        }
        if (this.end == Boundary.POSITIVE_INFINITY) {
            Boundary newStart = Boundary.NEGATIVE_INFINITY;
            Boundary newEnd = new Boundary(this.comparator, this.start.bound, !this.start.isInclusive);
            return new MarkerRange(this.comparator, newStart, newEnd);
        }
        return new MarkerRange();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MarkerRange)) {
            return false;
        }
        MarkerRange that = (MarkerRange)o;
        return Objects.equal(this.start, that.start) && Objects.equal(this.end, that.end);
    }

    public int hashCode() {
        return Objects.hashCode(this.start, this.end);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("start", this.start).add("end", this.end).toString();
    }

    public Boundary getStart() {
        return this.start;
    }

    public Boundary getEnd() {
        return this.end;
    }

    public static class Builder {
        private Marker.Builder start;
        private Marker.Builder end;
        private MarkerComparator comparator;

        public Builder(MarkerComparator comparator) {
            this.comparator = comparator;
        }

        public Builder addToStart(String name, Object value) {
            if (this.start == null) {
                this.start = new Marker.Builder();
            }
            this.start.add(name, value);
            return this;
        }

        public Builder addToEnd(String name, Object value) {
            if (this.end == null) {
                this.end = new Marker.Builder();
            }
            this.end.add(name, value);
            return this;
        }

        public MarkerRange build() {
            MarkerRange markerRange = new MarkerRange(this.comparator);
            if (this.start != null) {
                markerRange = markerRange.from(this.start.build());
            }
            if (this.end != null) {
                markerRange = markerRange.to(this.end.build());
            }
            return markerRange;
        }
    }

    public static class Boundary
    implements Comparable<Boundary> {
        private final MarkerComparator comparator;
        private final Marker bound;
        private final boolean isInclusive;
        public static final Boundary NEGATIVE_INFINITY = new Boundary(){

            @Override
            public boolean isLessThan(Marker other) {
                return true;
            }

            @Override
            public boolean isGreaterThan(Marker other) {
                return false;
            }

            @Override
            public boolean equals(Object o) {
                return this == o;
            }

            @Override
            public String toString() {
                return Objects.toStringHelper(this).add("bound", "NEGATIVE_INFINITY").toString();
            }
        };
        public static final Boundary POSITIVE_INFINITY = new Boundary(){

            @Override
            public boolean isLessThan(Marker other) {
                return false;
            }

            @Override
            public boolean isGreaterThan(Marker other) {
                return true;
            }

            @Override
            public boolean equals(Object o) {
                return this == o;
            }

            @Override
            public String toString() {
                return Objects.toStringHelper(this).add("bound", "POSITIVE_INFINITY").toString();
            }
        };

        private Boundary() {
            this.comparator = null;
            this.bound = null;
            this.isInclusive = false;
        }

        public Boundary(MarkerComparator comparator, Marker bound, boolean isInclusive) {
            Preconditions.checkArgument((comparator != null ? 1 : 0) != 0, (String)"Comparator cannot be null");
            Preconditions.checkArgument((bound != null ? 1 : 0) != 0, (String)"Bound cannot be null");
            this.comparator = comparator;
            this.bound = bound;
            this.isInclusive = isInclusive;
        }

        public boolean isLessThan(Marker other) {
            if (this.comparator == null) {
                return true;
            }
            if (this.isInclusive) {
                return this.comparator.leftCompare(this.bound, other) <= 0;
            }
            try {
                return this.comparator.compare(this.bound, other) < 0;
            }
            catch (IllegalStateException ex) {
                return false;
            }
        }

        public boolean isGreaterThan(Marker other) {
            if (this.comparator == null) {
                return true;
            }
            if (this.isInclusive) {
                return this.comparator.rightCompare(this.bound, other) >= 0;
            }
            try {
                return this.comparator.compare(this.bound, other) > 0;
            }
            catch (IllegalStateException ex) {
                return false;
            }
        }

        @Override
        public int compareTo(Boundary other) {
            if (this == NEGATIVE_INFINITY) {
                return other == NEGATIVE_INFINITY ? 0 : -1;
            }
            if (other == NEGATIVE_INFINITY) {
                return 1;
            }
            if (this == POSITIVE_INFINITY) {
                return other == POSITIVE_INFINITY ? 0 : 1;
            }
            if (other == POSITIVE_INFINITY) {
                return -1;
            }
            return this.comparator.compare(this.bound, other.bound);
        }

        public Marker getBound() {
            return this.bound;
        }

        public boolean isInclusive() {
            return this.isInclusive;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Boundary)) {
                return false;
            }
            Boundary that = (Boundary)o;
            return Objects.equal(this.isInclusive, that.isInclusive) && Objects.equal(this.bound, that.bound) && Objects.equal(this.comparator, that.comparator);
        }

        public int hashCode() {
            return Objects.hashCode(this.isInclusive, this.bound, this.comparator);
        }

        public String toString() {
            if (this.comparator == null) {
                return Objects.toStringHelper(this).add("bound", "UNBOUNDED").toString();
            }
            return Objects.toStringHelper(this).add("inclusive", this.isInclusive).add("bound", this.bound).add("comparator", this.comparator).toString();
        }

        public static class RightComparator
        implements Comparator<Boundary>,
        Serializable {
            private static final long serialVersionUID = 0L;

            @Override
            public int compare(Boundary b1, Boundary b2) {
                if (b1 == NEGATIVE_INFINITY) {
                    return b2 == NEGATIVE_INFINITY ? 0 : -1;
                }
                if (b2 == NEGATIVE_INFINITY) {
                    return 1;
                }
                if (b1 == POSITIVE_INFINITY) {
                    return b2 == POSITIVE_INFINITY ? 0 : 1;
                }
                if (b2 == POSITIVE_INFINITY) {
                    return -1;
                }
                if (b1.isInclusive) {
                    return b1.comparator.rightCompare(b1.bound, b2.bound);
                }
                try {
                    return b1.comparator.compare(b1.bound, b2.bound);
                }
                catch (IllegalStateException ex) {
                    return 0;
                }
            }
        }

        public static class LeftComparator
        implements Comparator<Boundary>,
        Serializable {
            private static final long serialVersionUID = 0L;

            @Override
            public int compare(Boundary b1, Boundary b2) {
                if (b1 == NEGATIVE_INFINITY) {
                    return b2 == NEGATIVE_INFINITY ? 0 : -1;
                }
                if (b2 == NEGATIVE_INFINITY) {
                    return 1;
                }
                if (b1 == POSITIVE_INFINITY) {
                    return b2 == POSITIVE_INFINITY ? 0 : 1;
                }
                if (b2 == POSITIVE_INFINITY) {
                    return -1;
                }
                if (b1.isInclusive) {
                    return b1.comparator.leftCompare(b1.bound, b2.bound);
                }
                try {
                    return b1.comparator.compare(b1.bound, b2.bound);
                }
                catch (IllegalStateException ex) {
                    return 0;
                }
            }
        }
    }
}

