/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.io.parsing.ResolvingGrammarGenerator;
import org.apache.avro.io.parsing.Symbol;

public class SchemaValidationUtil {
    public static boolean canRead(Schema writtenWith, Schema readUsing) {
        try {
            return !SchemaValidationUtil.hasErrors(new ResolvingGrammarGenerator().generate(writtenWith, readUsing));
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean hasErrors(Symbol symbol) {
        switch (symbol.kind) {
            case ALTERNATIVE: {
                return SchemaValidationUtil.hasErrors(symbol, ((Symbol.Alternative)symbol).symbols);
            }
            case EXPLICIT_ACTION: {
                return false;
            }
            case IMPLICIT_ACTION: {
                return symbol instanceof Symbol.ErrorAction;
            }
            case REPEATER: {
                Symbol.Repeater r = (Symbol.Repeater)symbol;
                return SchemaValidationUtil.hasErrors(r.end) || SchemaValidationUtil.hasErrors(symbol, r.production);
            }
            case ROOT: 
            case SEQUENCE: {
                return SchemaValidationUtil.hasErrors(symbol, symbol.production);
            }
            case TERMINAL: {
                return false;
            }
        }
        throw new RuntimeException("unknown symbol kind: " + symbol.kind);
    }

    private static boolean hasErrors(Symbol root, Symbol[] symbols) {
        if (null != symbols) {
            for (Symbol s : symbols) {
                if (s == root || !SchemaValidationUtil.hasErrors(s)) continue;
                return true;
            }
        }
        return false;
    }
}

