/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.reflect.ReflectData;
import org.kitesdk.data.DatasetOperationException;
import org.kitesdk.data.DatasetRecordException;
import org.kitesdk.data.spi.SchemaUtil;

class CSVRecordBuilder<E> {
    private final Schema schema;
    private final Class<E> recordClass;
    private final Schema.Field[] fields;
    private final int[] indexes;

    public CSVRecordBuilder(Schema schema, Class<E> recordClass, @Nullable List<String> header) {
        this.schema = schema;
        this.recordClass = recordClass;
        this.fields = schema.getFields().toArray(new Schema.Field[schema.getFields().size()]);
        this.indexes = new int[this.fields.length];
        if (header != null) {
            int i;
            for (i = 0; i < this.fields.length; ++i) {
                this.fields[i] = (Schema.Field)schema.getFields().get(i);
                this.indexes[i] = Integer.MAX_VALUE;
            }
            for (i = 0; i < header.size(); ++i) {
                Schema.Field field = schema.getField(header.get(i));
                if (field == null) continue;
                this.indexes[field.pos()] = i;
            }
        } else {
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = (Schema.Field)schema.getFields().get(i);
                this.indexes[i] = i;
            }
        }
    }

    public E makeRecord(String[] fields, @Nullable E reuse) {
        E record = reuse;
        if (record == null) {
            record = this.newRecordInstance();
        }
        if (record instanceof IndexedRecord) {
            this.fillIndexed((IndexedRecord)record, fields);
        } else {
            this.fillReflect(record, fields);
        }
        return record;
    }

    private E newRecordInstance() {
        Object record;
        if (this.recordClass != GenericData.Record.class && !this.recordClass.isInterface() && (record = ReflectData.newInstance(this.recordClass, (Schema)this.schema)) != null) {
            return (E)record;
        }
        return (E)new GenericData.Record(this.schema);
    }

    private void fillIndexed(IndexedRecord record, String[] data) {
        for (int i = 0; i < this.indexes.length; ++i) {
            int index = this.indexes[i];
            record.put(i, CSVRecordBuilder.makeValue(index < data.length ? data[index] : null, this.fields[i]));
        }
    }

    private void fillReflect(Object record, String[] data) {
        for (int i = 0; i < this.indexes.length; ++i) {
            Schema.Field field = this.fields[i];
            int index = this.indexes[i];
            Object value = CSVRecordBuilder.makeValue(index < data.length ? data[index] : null, field);
            ReflectData.get().setField(record, field.name(), i, value);
        }
    }

    private static Object makeValue(@Nullable String string, Schema.Field field) {
        try {
            Object value = CSVRecordBuilder.makeValue(string, field.schema());
            if (value != null || SchemaUtil.nullOk(field.schema())) {
                return value;
            }
            return ReflectData.get().getDefaultValue(field);
        }
        catch (DatasetRecordException e) {
            throw new DatasetRecordException(String.format("Cannot convert field %s", field.name()), e);
        }
        catch (NumberFormatException e) {
            throw new DatasetRecordException(String.format("Field %s: value not a %s: '%s'", field.name(), field.schema(), string), e);
        }
        catch (AvroRuntimeException e) {
            throw new DatasetRecordException(String.format("Field %s: cannot make %s value: '%s'", field.name(), field.schema(), string), e);
        }
    }

    private static Object makeValue(@Nullable String string, Schema schema) {
        if (string == null) {
            return null;
        }
        try {
            switch (schema.getType()) {
                case BOOLEAN: {
                    return Boolean.valueOf(string);
                }
                case STRING: {
                    return string;
                }
                case FLOAT: {
                    return Float.valueOf(string);
                }
                case DOUBLE: {
                    return Double.valueOf(string);
                }
                case INT: {
                    return Integer.valueOf(string);
                }
                case LONG: {
                    return Long.valueOf(string);
                }
                case ENUM: {
                    if (schema.hasEnumSymbol(string)) {
                        return string;
                    }
                    try {
                        return schema.getEnumSymbols().get(Integer.parseInt(string));
                    }
                    catch (IndexOutOfBoundsException ex) {
                        return null;
                    }
                }
                case UNION: {
                    Object value = null;
                    for (Schema possible : schema.getTypes()) {
                        value = CSVRecordBuilder.makeValue(string, possible);
                        if (value == null) continue;
                        return value;
                    }
                    return null;
                }
                case NULL: {
                    return null;
                }
            }
            throw new DatasetOperationException("Unsupported field type:" + schema.getType(), new Object[0]);
        }
        catch (NumberFormatException e) {
            if (string.isEmpty()) {
                return null;
            }
            throw e;
        }
    }
}

