/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.StorageKey;
import org.kitesdk.data.spi.filesystem.MultiLevelIterator;
import org.kitesdk.data.spi.filesystem.PathConversion;
import org.kitesdk.data.spi.filesystem.PathFilters;
import org.kitesdk.shaded.com.google.common.base.Function;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.base.Predicate;
import org.kitesdk.shaded.com.google.common.collect.Iterators;
import org.kitesdk.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileSystemPartitionIterator
implements Iterator<StorageKey>,
Iterable<StorageKey> {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemPartitionIterator.class);
    private final FileSystem fs;
    private final Path rootDirectory;
    private final Iterator<StorageKey> iterator;

    FileSystemPartitionIterator(FileSystem fs, Path root, PartitionStrategy strategy, Schema schema, Predicate<StorageKey> predicate) throws IOException {
        Preconditions.checkArgument(fs.isDirectory(root));
        this.fs = fs;
        this.rootDirectory = root;
        this.iterator = Iterators.filter(Iterators.transform(new FileSystemIterator(Accessor.getDefault().getFieldPartitioners(strategy).size()), new MakeKey(strategy, schema)), predicate);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public StorageKey next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public Iterator<StorageKey> iterator() {
        return this;
    }

    private static class MakeKey
    implements Function<List<String>, StorageKey> {
        private final StorageKey reusableKey;
        private final PathConversion convert;

        public MakeKey(PartitionStrategy strategy, Schema schema) {
            this.reusableKey = new StorageKey(strategy);
            this.convert = new PathConversion(schema);
        }

        @Override
        @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="Non-null @Nullable parameter inherited from Function")
        public StorageKey apply(List<String> dirs) {
            return this.reusableKey.reuseFor(dirs, this.convert);
        }
    }

    class FileSystemIterator
    extends MultiLevelIterator<String> {
        public FileSystemIterator(int depth) throws IOException {
            super(depth);
        }

        @Override
        public Iterable<String> getLevel(List<String> current) {
            LinkedHashSet<String> dirs = Sets.newLinkedHashSet();
            Path dir = FileSystemPartitionIterator.this.rootDirectory;
            int n = current.size();
            for (int i = 0; i < n; ++i) {
                dir = new Path(dir, current.get(i));
            }
            try {
                for (FileStatus stat : FileSystemPartitionIterator.this.fs.listStatus(dir, PathFilters.notHidden())) {
                    if (!stat.isDir()) continue;
                    dirs.add(stat.getPath().getName());
                }
            }
            catch (IOException ex) {
                throw new DatasetException("Cannot list directory:" + dir, ex);
            }
            return dirs;
        }
    }
}

