/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.kitesdk.compat.Hadoop;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.DatasetOperationException;
import org.kitesdk.data.spi.AbstractDatasetReader;
import org.kitesdk.data.spi.ReaderWriterState;
import org.kitesdk.data.spi.filesystem.InputFormatUtil;
import org.kitesdk.shaded.com.google.common.base.Preconditions;

public class InputFormatReader<E>
extends AbstractDatasetReader<E> {
    private static final TaskAttemptID FAKE_ID = new TaskAttemptID("", 0, false, 0, 0);
    private final FileSystem fs;
    private final Path path;
    private final Configuration conf;
    private final DatasetDescriptor descriptor;
    private final TaskAttemptContext attemptContext;
    private ReaderWriterState state = ReaderWriterState.NEW;
    private Iterator<InputSplit> splits;
    private RecordReader<E, Void> currentReader = null;
    private boolean hasNext = false;
    private boolean shouldAdvance = false;

    public InputFormatReader(FileSystem fs, Path path, DatasetDescriptor descriptor) {
        this.fs = fs;
        this.path = path;
        this.descriptor = descriptor;
        this.state = ReaderWriterState.NEW;
        this.conf = new Configuration(fs.getConf());
        for (String prop : descriptor.listProperties()) {
            this.conf.set(prop, descriptor.getProperty(prop));
        }
        this.attemptContext = (TaskAttemptContext)Hadoop.TaskAttemptContext.ctor.newInstance(new Object[]{this.conf, FAKE_ID});
    }

    @Override
    public void initialize() {
        Preconditions.checkState(ReaderWriterState.NEW.equals((Object)this.state), "A reader may not be opened more than once - current state:%s", new Object[]{this.state});
        try {
            FileInputFormat format = InputFormatUtil.newInputFormatInstance(this.descriptor);
            Job job = (Job)Hadoop.Job.newInstance.invoke(new Object[]{this.conf});
            FileInputFormat.addInputPath((Job)job, (Path)this.path);
            FileStatus stat = this.fs.getFileStatus(this.path);
            FileInputFormat.setMaxInputSplitSize((Job)job, (long)stat.getLen());
            this.splits = format.getSplits((JobContext)job).iterator();
            this.shouldAdvance = true;
            this.state = ReaderWriterState.OPEN;
        }
        catch (RuntimeException e) {
            this.state = ReaderWriterState.ERROR;
            throw new DatasetOperationException("Cannot calculate splits", e);
        }
        catch (IOException e) {
            this.state = ReaderWriterState.ERROR;
            throw new DatasetIOException("Cannot calculate splits", e);
        }
    }

    @Override
    public boolean hasNext() {
        Preconditions.checkState(ReaderWriterState.OPEN.equals((Object)this.state), "Attempt to read from a file in state:%s", new Object[]{this.state});
        if (this.shouldAdvance) {
            this.hasNext = this.advance();
            this.shouldAdvance = false;
        }
        return this.hasNext;
    }

    @Override
    public E next() {
        Preconditions.checkState(ReaderWriterState.OPEN.equals((Object)this.state), "Attempt to read from a file in state:%s", new Object[]{this.state});
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            Object record = this.currentReader.getCurrentKey();
            this.shouldAdvance = true;
            return (E)record;
        }
        catch (RuntimeException e) {
            this.state = ReaderWriterState.ERROR;
            throw new DatasetOperationException("Cannot get record", e);
        }
        catch (IOException e) {
            this.state = ReaderWriterState.ERROR;
            throw new DatasetIOException("Cannot get record", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.state = ReaderWriterState.ERROR;
            throw new DatasetOperationException("Interrupted", e);
        }
    }

    private boolean advance() {
        try {
            if (this.currentReader != null && this.currentReader.nextKeyValue()) {
                return true;
            }
            if (this.currentReader == null) {
                this.currentReader = InputFormatUtil.newRecordReader(this.descriptor);
            }
            while (this.splits.hasNext()) {
                InputSplit nextSplit = this.splits.next();
                this.currentReader.initialize(nextSplit, this.attemptContext);
                if (!this.currentReader.nextKeyValue()) continue;
                return true;
            }
            return false;
        }
        catch (RuntimeException e) {
            this.state = ReaderWriterState.ERROR;
            throw new DatasetOperationException("Cannot advance reader", e);
        }
        catch (IOException e) {
            this.state = ReaderWriterState.ERROR;
            throw new DatasetIOException("Cannot advance reader", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.state = ReaderWriterState.ERROR;
            throw new DatasetOperationException("Interrupted", e);
        }
    }

    @Override
    public void close() {
        if (!this.state.equals((Object)ReaderWriterState.OPEN)) {
            return;
        }
        this.state = ReaderWriterState.CLOSED;
        try {
            if (this.currentReader != null) {
                this.currentReader.close();
            }
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to close reader path:" + this.path, e);
        }
        this.hasNext = false;
    }

    @Override
    public boolean isOpen() {
        return ReaderWriterState.OPEN == this.state;
    }
}

