/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableInterpretable;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.interpreter.BindableRel;
import org.apache.calcite.interpreter.InterpretableRel;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Sink;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.runtime.ArrayBindable;
import org.apache.calcite.runtime.Bindable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerableBindable
extends ConverterImpl
implements BindableRel {
    protected EnumerableBindable(RelOptCluster cluster, RelNode input) {
        super(cluster, ConventionTraitDef.INSTANCE, cluster.traitSetOf(BindableConvention.INSTANCE), input);
    }

    @Override
    public EnumerableBindable copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableBindable(this.getCluster(), EnumerableBindable.sole(inputs));
    }

    @Override
    public Class<Object[]> getElementType() {
        return Object[].class;
    }

    @Override
    public Enumerable<Object[]> bind(DataContext dataContext) {
        ImmutableMap map = ImmutableMap.of();
        Bindable bindable = EnumerableInterpretable.toBindable((Map<String, Object>)map, null, (EnumerableRel)this.getInput(), EnumerableRel.Prefer.ARRAY);
        ArrayBindable arrayBindable = EnumerableInterpretable.box(bindable);
        return arrayBindable.bind(dataContext);
    }

    @Override
    public Node implement(final InterpretableRel.InterpreterImplementor implementor) {
        return new Node(){

            public void run() throws InterruptedException {
                Sink sink = implementor.relSinks.get(EnumerableBindable.this).get(0);
                Enumerable<Object[]> enumerable = EnumerableBindable.this.bind(implementor.dataContext);
                Enumerator enumerator = enumerable.enumerator();
                while (enumerator.moveNext()) {
                    sink.send(Row.asCopy((Object[])enumerator.current()));
                }
            }
        };
    }

    public static class EnumerableToBindableConverterRule
    extends ConverterRule {
        public static final EnumerableToBindableConverterRule INSTANCE = new EnumerableToBindableConverterRule();

        private EnumerableToBindableConverterRule() {
            super(EnumerableRel.class, EnumerableConvention.INSTANCE, BindableConvention.INSTANCE, "EnumerableToBindableConverterRule");
        }

        public RelNode convert(RelNode rel) {
            return new EnumerableBindable(rel.getCluster(), rel);
        }
    }
}

