/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BuiltInMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerableLimit
extends SingleRel
implements EnumerableRel {
    private final RexNode offset;
    private final RexNode fetch;

    public EnumerableLimit(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, child);
        this.offset = offset;
        this.fetch = fetch;
        assert (this.getConvention() instanceof EnumerableConvention);
        assert (this.getConvention() == child.getConvention());
    }

    @Override
    public EnumerableLimit copy(RelTraitSet traitSet, List<RelNode> newInputs) {
        return new EnumerableLimit(this.getCluster(), traitSet, EnumerableLimit.sole(newInputs), this.offset, this.fetch);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("offset", this.offset, this.offset != null).itemIf("fetch", this.fetch, this.fetch != null);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel child = (EnumerableRel)this.getInput();
        EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), result.format);
        Expression v = builder.append("child", result.block);
        if (this.offset != null) {
            v = builder.append("offset", (Expression)Expressions.call((Expression)v, (Method)BuiltInMethod.SKIP.method, (Expression[])new Expression[]{Expressions.constant((Object)RexLiteral.intValue(this.offset))}));
        }
        if (this.fetch != null) {
            v = builder.append("fetch", (Expression)Expressions.call((Expression)v, (Method)BuiltInMethod.TAKE.method, (Expression[])new Expression[]{Expressions.constant((Object)RexLiteral.intValue(this.fetch))}));
        }
        builder.add((Statement)Expressions.return_(null, (Expression)v));
        return implementor.result(physType, builder.toBlock());
    }
}

