/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel;

public class RelFieldCollation {
    private final int fieldIndex;
    public final Direction direction;
    public final NullDirection nullDirection;

    public RelFieldCollation(int fieldIndex) {
        this(fieldIndex, Direction.ASCENDING, NullDirection.UNSPECIFIED);
    }

    public RelFieldCollation(int fieldIndex, Direction direction) {
        this(fieldIndex, direction, NullDirection.UNSPECIFIED);
    }

    public RelFieldCollation(int fieldIndex, Direction direction, NullDirection nullDirection) {
        this.fieldIndex = fieldIndex;
        this.direction = direction;
        this.nullDirection = nullDirection;
        assert (direction != null);
        assert (nullDirection != null);
    }

    public RelFieldCollation copy(int target) {
        if (target == this.fieldIndex) {
            return this;
        }
        return new RelFieldCollation(target, this.direction, this.nullDirection);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RelFieldCollation)) {
            return false;
        }
        RelFieldCollation other = (RelFieldCollation)obj;
        return this.fieldIndex == other.fieldIndex && this.direction == other.direction && this.nullDirection == other.nullDirection;
    }

    public int hashCode() {
        return this.fieldIndex | this.direction.ordinal() << 4 | this.nullDirection.ordinal() << 8;
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public String toString() {
        return this.fieldIndex + " " + this.direction.shortString + (this.nullDirection == NullDirection.UNSPECIFIED ? "" : " " + (Object)((Object)this.nullDirection));
    }

    public String shortString() {
        switch (this.nullDirection) {
            case FIRST: {
                return this.direction.shortString + "-nulls-first";
            }
            case LAST: {
                return this.direction.shortString + "-nulls-last";
            }
        }
        return this.direction.shortString;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NullDirection {
        FIRST,
        LAST,
        UNSPECIFIED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        ASCENDING("ASC"),
        STRICTLY_ASCENDING("SASC"),
        DESCENDING("DESC"),
        STRICTLY_DESCENDING("SDESC"),
        CLUSTERED("CLU");

        public final String shortString;

        private Direction(String shortString) {
            this.shortString = shortString;
        }
    }
}

