/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.logical.LogicalJoin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinAddRedundantSemiJoinRule
extends RelOptRule {
    public static final JoinAddRedundantSemiJoinRule INSTANCE = new JoinAddRedundantSemiJoinRule(LogicalJoin.class);

    private JoinAddRedundantSemiJoinRule(Class<? extends Join> clazz) {
        super(JoinAddRedundantSemiJoinRule.operand(clazz, JoinAddRedundantSemiJoinRule.any()));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join origJoinRel = (Join)call.rel(0);
        if (origJoinRel.isSemiJoinDone()) {
            return;
        }
        if (origJoinRel.getJoinType() != JoinRelType.INNER) {
            return;
        }
        JoinInfo joinInfo = origJoinRel.analyzeCondition();
        if (joinInfo.leftKeys.size() == 0) {
            return;
        }
        SemiJoin semiJoin = new SemiJoin(origJoinRel.getCluster(), origJoinRel.getCluster().traitSetOf(Convention.NONE), origJoinRel.getLeft(), origJoinRel.getRight(), origJoinRel.getCondition(), joinInfo.leftKeys, joinInfo.rightKeys);
        Join newJoinRel = origJoinRel.copy(origJoinRel.getTraitSet(), origJoinRel.getCondition(), semiJoin, origJoinRel.getRight(), JoinRelType.INNER, true);
        call.transformTo(newJoinRel);
    }
}

