/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.base.Predicate;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectRemoveRule
extends RelOptRule {
    private final boolean useNamesInIdentityProjCalc;
    private static final Predicate<Project> PREDICATE = new Predicate<Project>(){

        public boolean apply(Project input) {
            return ProjectRemoveRule.isTrivial(input, false);
        }
    };
    private static final Predicate<Project> NAME_CALC_PREDICATE = new Predicate<Project>(){

        public boolean apply(Project input) {
            return ProjectRemoveRule.isTrivial(input, true);
        }
    };
    public static final ProjectRemoveRule INSTANCE = new ProjectRemoveRule(false);
    public static final ProjectRemoveRule NAME_CALC_INSTANCE = new ProjectRemoveRule(true);

    private ProjectRemoveRule(boolean useNamesInIdentityProjCalc) {
        super(ProjectRemoveRule.operand(Project.class, null, useNamesInIdentityProjCalc ? NAME_CALC_PREDICATE : PREDICATE, ProjectRemoveRule.any()));
        this.useNamesInIdentityProjCalc = useNamesInIdentityProjCalc;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        assert (ProjectRemoveRule.isTrivial(project, this.useNamesInIdentityProjCalc));
        RelNode stripped = project.getInput();
        if (stripped instanceof Project) {
            Project childProject = (Project)stripped;
            stripped = childProject.copy(childProject.getTraitSet(), childProject.getInput(), childProject.getProjects(), project.getRowType());
        }
        RelNode child = call.getPlanner().register(stripped, project);
        call.transformTo(child);
    }

    public static RelNode strip(Project project) {
        return ProjectRemoveRule.isTrivial(project) ? project.getInput() : project;
    }

    public static RelNode strip(Project project, boolean useNamesInIdentityProjCalc) {
        return ProjectRemoveRule.isTrivial(project, useNamesInIdentityProjCalc) ? project.getInput() : project;
    }

    public static boolean isTrivial(Project project) {
        return ProjectRemoveRule.isTrivial(project, false);
    }

    public static boolean isTrivial(Project project, boolean useNamesInIdentityProjCalc) {
        RelNode child = project.getInput();
        RelDataType childRowType = child.getRowType();
        if (useNamesInIdentityProjCalc) {
            return ProjectRemoveRule.isIdentity(project.getProjects(), project.getRowType(), childRowType);
        }
        return ProjectRemoveRule.isIdentity(project.getProjects(), childRowType);
    }

    public static boolean isIdentity(List<? extends RexNode> exps, RelDataType childRowType) {
        return childRowType.getFieldCount() == exps.size() && RexUtil.containIdentity(exps, childRowType, false);
    }

    public static boolean isIdentity(List<? extends RexNode> exps, RelDataType rowType, RelDataType childRowType) {
        return childRowType.getFieldCount() == exps.size() && RexUtil.containIdentity(exps, rowType, childRowType);
    }
}

