/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableInterpreter;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.schema.ProjectableFilterableTable;

public abstract class ProjectTableRule
extends RelOptRule {
    private static final Predicate<TableScan> PREDICATE = new Predicate<TableScan>(){

        public boolean apply(TableScan scan) {
            RelOptTable table = scan.getTable();
            return table.unwrap(ProjectableFilterableTable.class) != null;
        }
    };
    public static final ProjectTableRule INSTANCE = new ProjectTableRule(ProjectTableRule.operand(Project.class, ProjectTableRule.operand(EnumerableInterpreter.class, ProjectTableRule.operand(TableScan.class, null, PREDICATE, ProjectTableRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "ProjectTableRule:basic"){

        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            EnumerableInterpreter interpreter = (EnumerableInterpreter)call.rel(1);
            TableScan scan = (TableScan)call.rel(2);
            RelOptTable table = scan.getTable();
            assert (table.unwrap(ProjectableFilterableTable.class) != null);
            this.apply(call, project, null, interpreter);
        }
    };
    public static final ProjectTableRule INSTANCE2 = new ProjectTableRule(ProjectTableRule.operand(Project.class, ProjectTableRule.operand(Filter.class, ProjectTableRule.operand(EnumerableInterpreter.class, ProjectTableRule.operand(TableScan.class, null, PREDICATE, ProjectTableRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "ProjectTableRule:filter"){

        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            Filter filter = (Filter)call.rel(1);
            EnumerableInterpreter interpreter = (EnumerableInterpreter)call.rel(2);
            TableScan scan = (TableScan)call.rel(3);
            RelOptTable table = scan.getTable();
            assert (table.unwrap(ProjectableFilterableTable.class) != null);
            this.apply(call, project, filter, interpreter);
        }
    };

    private ProjectTableRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    protected void apply(RelOptRuleCall call, Project project, Filter filter, EnumerableInterpreter interpreter) {
        ArrayList extraProjects;
        final RexBuilder rexBuilder = project.getCluster().getRexBuilder();
        RexProgram program = RexProgram.create(interpreter.getRowType(), project.getProjects(), null, project.getRowType(), rexBuilder);
        final ArrayList projectOrdinals = Lists.newArrayList();
        if (program.getExprList().size() == program.getInputRowType().getFieldCount()) {
            for (RexLocalRef ref : program.getProjectList()) {
                projectOrdinals.add(ref.getIndex());
            }
            extraProjects = null;
        } else {
            extraProjects = Lists.newArrayList();
            RexShuttle shuttle = new RexShuttle(){
                final List<RexInputRef> inputRefs = Lists.newArrayList();

                public RexNode visitInputRef(RexInputRef inputRef) {
                    RexInputRef ref;
                    int source = inputRef.getIndex();
                    int target = projectOrdinals.indexOf(source);
                    if (target < 0) {
                        target = projectOrdinals.size();
                        projectOrdinals.add(source);
                        ref = rexBuilder.makeInputRef(inputRef.getType(), target);
                        this.inputRefs.add(ref);
                    } else {
                        ref = this.inputRefs.get(target);
                    }
                    return ref;
                }
            };
            for (RexNode node : project.getProjects()) {
                extraProjects.add(node.accept(shuttle));
            }
        }
        RelNode input = interpreter.getInput();
        if (filter != null) {
            input = RelOptUtil.createFilter(input, filter.getCondition(), EnumerableRel.FILTER_FACTORY);
        }
        RelNode newProject = RelOptUtil.createProject(EnumerableRel.PROJECT_FACTORY, input, projectOrdinals);
        EnumerableInterpreter newInterpreter = new EnumerableInterpreter(interpreter.getCluster(), interpreter.getTraitSet(), newProject, 0.15);
        RelNode residue = extraProjects != null ? RelOptUtil.createProject((RelNode)newInterpreter, extraProjects, project.getRowType().getFieldNames()) : newInterpreter;
        call.transformTo(residue);
    }
}

