/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.util.Static;

public class MultisetOperandTypeChecker
implements SqlOperandTypeChecker {
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlCall call = callBinding.getCall();
        Object op0 = call.operand(0);
        if (!OperandTypes.MULTISET.checkSingleOperandType(callBinding, (SqlNode)op0, 0, throwOnFailure)) {
            return false;
        }
        Object op1 = call.operand(1);
        if (!OperandTypes.MULTISET.checkSingleOperandType(callBinding, (SqlNode)op1, 0, throwOnFailure)) {
            return false;
        }
        RelDataType biggest = callBinding.getTypeFactory().leastRestrictive((List<RelDataType>)ImmutableList.of((Object)callBinding.getValidator().deriveType(callBinding.getScope(), (SqlNode)op0).getComponentType(), (Object)callBinding.getValidator().deriveType(callBinding.getScope(), (SqlNode)op1).getComponentType()));
        if (null == biggest) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.typeNotComparable(((SqlNode)op0).getParserPosition().toString(), ((SqlNode)op1).getParserPosition().toString()));
            }
            return false;
        }
        return true;
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    public String getAllowedSignatures(SqlOperator op, String opName) {
        return "<MULTISET> " + opName + " <MULTISET>";
    }
}

