/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListSqlOperatorTable
implements SqlOperatorTable {
    private final List<SqlOperator> operatorList;

    public ListSqlOperatorTable() {
        this(new ArrayList<SqlOperator>());
    }

    public ListSqlOperatorTable(List<SqlOperator> operatorList) {
        this.operatorList = operatorList;
    }

    public void add(SqlOperator op) {
        this.operatorList.add(op);
    }

    @Override
    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList) {
        for (SqlOperator operator : this.operatorList) {
            SqlFunctionCategory functionCategory;
            if (operator.getSyntax() != syntax || !opName.isSimple() || !operator.isName(opName.getSimple()) || category != (functionCategory = operator instanceof SqlFunction ? ((SqlFunction)operator).getFunctionType() : SqlFunctionCategory.SYSTEM) && category != SqlFunctionCategory.USER_DEFINED_FUNCTION) continue;
            operatorList.add(operator);
        }
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        return this.operatorList;
    }
}

