/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TableNamespace
extends AbstractNamespace {
    private final SqlValidatorTable table;
    public final ImmutableList<RelDataTypeField> extendedFields;

    TableNamespace(SqlValidatorImpl validator, SqlValidatorTable table, ImmutableList<RelDataTypeField> fields) {
        super(validator, null);
        this.table = (SqlValidatorTable)Preconditions.checkNotNull((Object)table);
        this.extendedFields = fields;
    }

    public TableNamespace(SqlValidatorImpl validator, SqlValidatorTable table) {
        this(validator, table, (ImmutableList<RelDataTypeField>)ImmutableList.of());
    }

    @Override
    protected RelDataType validateImpl() {
        if (this.extendedFields.isEmpty()) {
            return this.table.getRowType();
        }
        RelDataTypeFactory.FieldInfoBuilder builder = this.validator.getTypeFactory().builder();
        builder.addAll(this.table.getRowType().getFieldList());
        builder.addAll((Iterable<? extends Map.Entry<String, RelDataType>>)this.extendedFields);
        return builder.build();
    }

    @Override
    public SqlNode getNode() {
        return null;
    }

    @Override
    public SqlValidatorTable getTable() {
        return this.table;
    }

    public TableNamespace extend(List<RelDataTypeField> extendedFields) {
        return new TableNamespace(this.validator, this.table, (ImmutableList<RelDataTypeField>)ImmutableList.copyOf((Iterable)Iterables.concat(this.extendedFields, extendedFields)));
    }
}

