/*
 * Decompiled with CFR 0.152.
 */
package parquet.filter2.recordlevel;

import parquet.filter2.predicate.Operators;
import parquet.filter2.predicate.UserDefinedPredicate;
import parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate;
import parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicateBuilderBase;
import parquet.hadoop.metadata.ColumnPath;
import parquet.io.api.Binary;

public class IncrementallyUpdatedFilterPredicateBuilder
extends IncrementallyUpdatedFilterPredicateBuilderBase {
    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.Eq<T> pred) {
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(int value) {
                        this.setResult(false);
                    }
                };
            } else {
                final int n = (Integer)pred.getValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(int value) {
                        this.setResult(value == n);
                    }
                };
            }
        }
        if (clazz.equals(Long.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(long value) {
                        this.setResult(false);
                    }
                };
            } else {
                final long target2 = (Long)pred.getValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(long value) {
                        this.setResult(value == target2);
                    }
                };
            }
        }
        if (clazz.equals(Boolean.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(boolean value) {
                        this.setResult(false);
                    }
                };
            } else {
                final boolean bl = (Boolean)pred.getValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(boolean value) {
                        this.setResult(value == bl);
                    }
                };
            }
        }
        if (clazz.equals(Float.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(float value) {
                        this.setResult(false);
                    }
                };
            } else {
                final float f = ((Float)pred.getValue()).floatValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(float value) {
                        this.setResult(value == f);
                    }
                };
            }
        }
        if (clazz.equals(Double.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(double value) {
                        this.setResult(false);
                    }
                };
            } else {
                final double target4 = (Double)pred.getValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(double value) {
                        this.setResult(value == target4);
                    }
                };
            }
        }
        if (clazz.equals(Binary.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(Binary value) {
                        this.setResult(false);
                    }
                };
            } else {
                final Binary binary = (Binary)pred.getValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(Binary value) {
                        this.setResult(value.compareTo(binary) == 0);
                    }
                };
            }
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.NotEq<T> pred) {
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(int value) {
                        this.setResult(true);
                    }
                };
            } else {
                final int n = (Integer)pred.getValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(int value) {
                        this.setResult(value != n);
                    }
                };
            }
        }
        if (clazz.equals(Long.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(long value) {
                        this.setResult(true);
                    }
                };
            } else {
                final long target2 = (Long)pred.getValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(long value) {
                        this.setResult(value != target2);
                    }
                };
            }
        }
        if (clazz.equals(Boolean.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(boolean value) {
                        this.setResult(true);
                    }
                };
            } else {
                final boolean bl = (Boolean)pred.getValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(boolean value) {
                        this.setResult(value != bl);
                    }
                };
            }
        }
        if (clazz.equals(Float.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(float value) {
                        this.setResult(true);
                    }
                };
            } else {
                final float f = ((Float)pred.getValue()).floatValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(float value) {
                        this.setResult(value != f);
                    }
                };
            }
        }
        if (clazz.equals(Double.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(double value) {
                        this.setResult(true);
                    }
                };
            } else {
                final double target4 = (Double)pred.getValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(double value) {
                        this.setResult(value != target4);
                    }
                };
            }
        }
        if (clazz.equals(Binary.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(Binary value) {
                        this.setResult(true);
                    }
                };
            } else {
                final Binary binary = (Binary)pred.getValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(Binary value) {
                        this.setResult(value.compareTo(binary) != 0);
                    }
                };
            }
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.Lt<T> pred) {
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            final int target = (Integer)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(int value) {
                    this.setResult(value < target);
                }
            };
        }
        if (clazz.equals(Long.class)) {
            final long target = (Long)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(long value) {
                    this.setResult(value < target);
                }
            };
        }
        if (clazz.equals(Boolean.class)) {
            throw new IllegalArgumentException("Operator < not supported for Boolean");
        }
        if (clazz.equals(Float.class)) {
            final float target = ((Float)pred.getValue()).floatValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(float value) {
                    this.setResult(value < target);
                }
            };
        }
        if (clazz.equals(Double.class)) {
            final double target = (Double)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(double value) {
                    this.setResult(value < target);
                }
            };
        }
        if (clazz.equals(Binary.class)) {
            final Binary target = (Binary)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(Binary value) {
                    this.setResult(value.compareTo(target) < 0);
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.LtEq<T> pred) {
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            final int target = (Integer)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(int value) {
                    this.setResult(value <= target);
                }
            };
        }
        if (clazz.equals(Long.class)) {
            final long target = (Long)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(long value) {
                    this.setResult(value <= target);
                }
            };
        }
        if (clazz.equals(Boolean.class)) {
            throw new IllegalArgumentException("Operator <= not supported for Boolean");
        }
        if (clazz.equals(Float.class)) {
            final float target = ((Float)pred.getValue()).floatValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(float value) {
                    this.setResult(value <= target);
                }
            };
        }
        if (clazz.equals(Double.class)) {
            final double target = (Double)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(double value) {
                    this.setResult(value <= target);
                }
            };
        }
        if (clazz.equals(Binary.class)) {
            final Binary target = (Binary)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(Binary value) {
                    this.setResult(value.compareTo(target) <= 0);
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.Gt<T> pred) {
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            final int target = (Integer)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(int value) {
                    this.setResult(value > target);
                }
            };
        }
        if (clazz.equals(Long.class)) {
            final long target = (Long)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(long value) {
                    this.setResult(value > target);
                }
            };
        }
        if (clazz.equals(Boolean.class)) {
            throw new IllegalArgumentException("Operator > not supported for Boolean");
        }
        if (clazz.equals(Float.class)) {
            final float target = ((Float)pred.getValue()).floatValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(float value) {
                    this.setResult(value > target);
                }
            };
        }
        if (clazz.equals(Double.class)) {
            final double target = (Double)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(double value) {
                    this.setResult(value > target);
                }
            };
        }
        if (clazz.equals(Binary.class)) {
            final Binary target = (Binary)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(Binary value) {
                    this.setResult(value.compareTo(target) > 0);
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.GtEq<T> pred) {
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            final int target = (Integer)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(int value) {
                    this.setResult(value >= target);
                }
            };
        }
        if (clazz.equals(Long.class)) {
            final long target = (Long)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(long value) {
                    this.setResult(value >= target);
                }
            };
        }
        if (clazz.equals(Boolean.class)) {
            throw new IllegalArgumentException("Operator >= not supported for Boolean");
        }
        if (clazz.equals(Float.class)) {
            final float target = ((Float)pred.getValue()).floatValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(float value) {
                    this.setResult(value >= target);
                }
            };
        }
        if (clazz.equals(Double.class)) {
            final double target = (Double)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(double value) {
                    this.setResult(value >= target);
                }
            };
        }
        if (clazz.equals(Binary.class)) {
            final Binary target = (Binary)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(Binary value) {
                    this.setResult(value.compareTo(target) >= 0);
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> IncrementallyUpdatedFilterPredicate visit(Operators.UserDefined<T, U> pred) {
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class<T> clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        U udp = pred.getUserDefinedPredicate();
        if (clazz.equals(Integer.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.keep(null));
                }

                @Override
                public void update(int value) {
                    this.setResult(this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Long.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.keep(null));
                }

                @Override
                public void update(long value) {
                    this.setResult(this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Boolean.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.keep(null));
                }

                @Override
                public void update(boolean value) {
                    this.setResult(this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Float.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.keep(null));
                }

                @Override
                public void update(float value) {
                    this.setResult(this.val$udp.keep((Comparable)Float.valueOf(value)));
                }
            };
        }
        if (clazz.equals(Double.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.keep(null));
                }

                @Override
                public void update(double value) {
                    this.setResult(this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Binary.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.keep(null));
                }

                @Override
                public void update(Binary value) {
                    this.setResult(this.val$udp.keep((Comparable)value));
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> IncrementallyUpdatedFilterPredicate visit(Operators.LogicalNotUserDefined<T, U> notPred) {
        Operators.UserDefined<T, U> pred = notPred.getUserDefined();
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class<T> clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        U udp = pred.getUserDefinedPredicate();
        if (clazz.equals(Integer.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.keep(null));
                }

                @Override
                public void update(int value) {
                    this.setResult(!this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Long.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.keep(null));
                }

                @Override
                public void update(long value) {
                    this.setResult(!this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Boolean.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.keep(null));
                }

                @Override
                public void update(boolean value) {
                    this.setResult(!this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Float.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.keep(null));
                }

                @Override
                public void update(float value) {
                    this.setResult(!this.val$udp.keep((Comparable)Float.valueOf(value)));
                }
            };
        }
        if (clazz.equals(Double.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.keep(null));
                }

                @Override
                public void update(double value) {
                    this.setResult(!this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Binary.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.keep(null));
                }

                @Override
                public void update(Binary value) {
                    this.setResult(!this.val$udp.keep((Comparable)value));
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }
}

