/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleRequest;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleResponse;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.thrift.TException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface IMetaStoreClient {
    public boolean isCompatibleWith(HiveConf var1);

    public void reconnect() throws MetaException;

    public void close();

    public void setMetaConf(String var1, String var2) throws MetaException, TException;

    public String getMetaConf(String var1) throws MetaException, TException;

    public List<String> getDatabases(String var1) throws MetaException, TException;

    public List<String> getAllDatabases() throws MetaException, TException;

    public List<String> getTables(String var1, String var2) throws MetaException, TException, UnknownDBException;

    public List<String> getAllTables(String var1) throws MetaException, TException, UnknownDBException;

    public List<String> listTableNamesByFilter(String var1, String var2, short var3) throws MetaException, TException, InvalidOperationException, UnknownDBException;

    public void dropTable(String var1, String var2, boolean var3, boolean var4) throws MetaException, TException, NoSuchObjectException;

    public void dropTable(String var1, String var2, boolean var3, boolean var4, boolean var5) throws MetaException, TException, NoSuchObjectException;

    @Deprecated
    public void dropTable(String var1, boolean var2) throws MetaException, UnknownTableException, TException, NoSuchObjectException;

    public void dropTable(String var1, String var2) throws MetaException, TException, NoSuchObjectException;

    public boolean tableExists(String var1, String var2) throws MetaException, TException, UnknownDBException;

    @Deprecated
    public boolean tableExists(String var1) throws MetaException, TException, UnknownDBException;

    @Deprecated
    public Table getTable(String var1) throws MetaException, TException, NoSuchObjectException;

    public Database getDatabase(String var1) throws NoSuchObjectException, MetaException, TException;

    public Table getTable(String var1, String var2) throws MetaException, TException, NoSuchObjectException;

    public List<Table> getTableObjectsByName(String var1, List<String> var2) throws MetaException, InvalidOperationException, UnknownDBException, TException;

    public Partition appendPartition(String var1, String var2, List<String> var3) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public Partition appendPartition(String var1, String var2, String var3) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public Partition add_partition(Partition var1) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public int add_partitions(List<Partition> var1) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public int add_partitions_pspec(PartitionSpecProxy var1) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public List<Partition> add_partitions(List<Partition> var1, boolean var2, boolean var3) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public Partition getPartition(String var1, String var2, List<String> var3) throws NoSuchObjectException, MetaException, TException;

    public Partition exchange_partition(Map<String, String> var1, String var2, String var3, String var4, String var5) throws MetaException, NoSuchObjectException, InvalidObjectException, TException;

    public Partition getPartition(String var1, String var2, String var3) throws MetaException, UnknownTableException, NoSuchObjectException, TException;

    public Partition getPartitionWithAuthInfo(String var1, String var2, List<String> var3, String var4, List<String> var5) throws MetaException, UnknownTableException, NoSuchObjectException, TException;

    public List<Partition> listPartitions(String var1, String var2, short var3) throws NoSuchObjectException, MetaException, TException;

    public PartitionSpecProxy listPartitionSpecs(String var1, String var2, int var3) throws TException;

    public List<Partition> listPartitions(String var1, String var2, List<String> var3, short var4) throws NoSuchObjectException, MetaException, TException;

    public List<String> listPartitionNames(String var1, String var2, short var3) throws MetaException, TException;

    public List<String> listPartitionNames(String var1, String var2, List<String> var3, short var4) throws MetaException, TException, NoSuchObjectException;

    public List<Partition> listPartitionsByFilter(String var1, String var2, String var3, short var4) throws MetaException, NoSuchObjectException, TException;

    public PartitionSpecProxy listPartitionSpecsByFilter(String var1, String var2, String var3, int var4) throws MetaException, NoSuchObjectException, TException;

    public boolean listPartitionsByExpr(String var1, String var2, byte[] var3, String var4, short var5, List<Partition> var6) throws TException;

    public List<Partition> listPartitionsWithAuthInfo(String var1, String var2, short var3, String var4, List<String> var5) throws MetaException, TException, NoSuchObjectException;

    public List<Partition> getPartitionsByNames(String var1, String var2, List<String> var3) throws NoSuchObjectException, MetaException, TException;

    public List<Partition> listPartitionsWithAuthInfo(String var1, String var2, List<String> var3, short var4, String var5, List<String> var6) throws MetaException, TException, NoSuchObjectException;

    public void markPartitionForEvent(String var1, String var2, Map<String, String> var3, PartitionEventType var4) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException;

    public boolean isPartitionMarkedForEvent(String var1, String var2, Map<String, String> var3, PartitionEventType var4) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException;

    public void validatePartitionNameCharacters(List<String> var1) throws TException, MetaException;

    public void createTable(Table var1) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException;

    public void alter_table(String var1, String var2, Table var3) throws InvalidOperationException, MetaException, TException;

    public void alter_table(String var1, String var2, Table var3, boolean var4) throws InvalidOperationException, MetaException, TException;

    public void createDatabase(Database var1) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public void dropDatabase(String var1) throws NoSuchObjectException, InvalidOperationException, MetaException, TException;

    public void dropDatabase(String var1, boolean var2, boolean var3) throws NoSuchObjectException, InvalidOperationException, MetaException, TException;

    public void dropDatabase(String var1, boolean var2, boolean var3, boolean var4) throws NoSuchObjectException, InvalidOperationException, MetaException, TException;

    public void alterDatabase(String var1, Database var2) throws NoSuchObjectException, MetaException, TException;

    public boolean dropPartition(String var1, String var2, List<String> var3, boolean var4) throws NoSuchObjectException, MetaException, TException;

    public List<Partition> dropPartitions(String var1, String var2, List<ObjectPair<Integer, byte[]>> var3, boolean var4, boolean var5, boolean var6) throws NoSuchObjectException, MetaException, TException;

    public boolean dropPartition(String var1, String var2, String var3, boolean var4) throws NoSuchObjectException, MetaException, TException;

    public void alter_partition(String var1, String var2, Partition var3) throws InvalidOperationException, MetaException, TException;

    public void alter_partitions(String var1, String var2, List<Partition> var3) throws InvalidOperationException, MetaException, TException;

    public void renamePartition(String var1, String var2, List<String> var3, Partition var4) throws InvalidOperationException, MetaException, TException;

    public List<FieldSchema> getFields(String var1, String var2) throws MetaException, TException, UnknownTableException, UnknownDBException;

    public List<FieldSchema> getSchema(String var1, String var2) throws MetaException, TException, UnknownTableException, UnknownDBException;

    public String getConfigValue(String var1, String var2) throws TException, ConfigValSecurityException;

    public List<String> partitionNameToVals(String var1) throws MetaException, TException;

    public Map<String, String> partitionNameToSpec(String var1) throws MetaException, TException;

    public void createIndex(Index var1, Table var2) throws InvalidObjectException, MetaException, NoSuchObjectException, TException, AlreadyExistsException;

    public void alter_index(String var1, String var2, String var3, Index var4) throws InvalidOperationException, MetaException, TException;

    public Index getIndex(String var1, String var2, String var3) throws MetaException, UnknownTableException, NoSuchObjectException, TException;

    public List<Index> listIndexes(String var1, String var2, short var3) throws NoSuchObjectException, MetaException, TException;

    public List<String> listIndexNames(String var1, String var2, short var3) throws MetaException, TException;

    public boolean dropIndex(String var1, String var2, String var3, boolean var4) throws NoSuchObjectException, MetaException, TException;

    public boolean updateTableColumnStatistics(ColumnStatistics var1) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException;

    public boolean updatePartitionColumnStatistics(ColumnStatistics var1) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException;

    public List<ColumnStatisticsObj> getTableColumnStatistics(String var1, String var2, List<String> var3) throws NoSuchObjectException, MetaException, TException;

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String var1, String var2, List<String> var3, List<String> var4) throws NoSuchObjectException, MetaException, TException;

    public boolean deletePartitionColumnStatistics(String var1, String var2, String var3, String var4) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException;

    public boolean deleteTableColumnStatistics(String var1, String var2, String var3) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException;

    public boolean create_role(Role var1) throws MetaException, TException;

    public boolean drop_role(String var1) throws MetaException, TException;

    public List<String> listRoleNames() throws MetaException, TException;

    public boolean grant_role(String var1, String var2, PrincipalType var3, String var4, PrincipalType var5, boolean var6) throws MetaException, TException;

    public boolean revoke_role(String var1, String var2, PrincipalType var3, boolean var4) throws MetaException, TException;

    public List<Role> list_roles(String var1, PrincipalType var2) throws MetaException, TException;

    public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef var1, String var2, List<String> var3) throws MetaException, TException;

    public List<HiveObjectPrivilege> list_privileges(String var1, PrincipalType var2, HiveObjectRef var3) throws MetaException, TException;

    public boolean grant_privileges(PrivilegeBag var1) throws MetaException, TException;

    public boolean revoke_privileges(PrivilegeBag var1, boolean var2) throws MetaException, TException;

    public String getDelegationToken(String var1, String var2) throws MetaException, TException;

    public long renewDelegationToken(String var1) throws MetaException, TException;

    public void cancelDelegationToken(String var1) throws MetaException, TException;

    public void createFunction(Function var1) throws InvalidObjectException, MetaException, TException;

    public void alterFunction(String var1, String var2, Function var3) throws InvalidObjectException, MetaException, TException;

    public void dropFunction(String var1, String var2) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException, TException;

    public Function getFunction(String var1, String var2) throws MetaException, TException;

    public List<String> getFunctions(String var1, String var2) throws MetaException, TException;

    public ValidTxnList getValidTxns() throws TException;

    public ValidTxnList getValidTxns(long var1) throws TException;

    public long openTxn(String var1) throws TException;

    public OpenTxnsResponse openTxns(String var1, int var2) throws TException;

    public void rollbackTxn(long var1) throws NoSuchTxnException, TException;

    public void commitTxn(long var1) throws NoSuchTxnException, TxnAbortedException, TException;

    public GetOpenTxnsInfoResponse showTxns() throws TException;

    public LockResponse lock(LockRequest var1) throws NoSuchTxnException, TxnAbortedException, TException;

    public LockResponse checkLock(long var1) throws NoSuchTxnException, TxnAbortedException, NoSuchLockException, TException;

    public void unlock(long var1) throws NoSuchLockException, TxnOpenException, TException;

    public ShowLocksResponse showLocks() throws TException;

    public void heartbeat(long var1, long var3) throws NoSuchLockException, NoSuchTxnException, TxnAbortedException, TException;

    public HeartbeatTxnRangeResponse heartbeatTxnRange(long var1, long var3) throws TException;

    public void compact(String var1, String var2, String var3, CompactionType var4) throws TException;

    public ShowCompactResponse showCompactions() throws TException;

    public NotificationEventResponse getNextNotification(long var1, int var3, NotificationFilter var4) throws TException;

    public CurrentNotificationEventId getCurrentNotificationEventId() throws TException;

    public GetPrincipalsInRoleResponse get_principals_in_role(GetPrincipalsInRoleRequest var1) throws MetaException, TException;

    public GetRoleGrantsForPrincipalResponse get_role_grants_for_principal(GetRoleGrantsForPrincipalRequest var1) throws MetaException, TException;

    public AggrStats getAggrColStatsFor(String var1, String var2, List<String> var3, List<String> var4) throws NoSuchObjectException, MetaException, TException;

    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest var1) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException;

    public static class IncompatibleMetastoreException
    extends MetaException {
        IncompatibleMetastoreException(String message) {
            super(message);
        }
    }

    public static interface NotificationFilter {
        public boolean accept(NotificationEvent var1);
    }
}

