/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestIPv6NIOServerSocketChannel {
    private static final Log LOG = LogFactory.getLog(TestIPv6NIOServerSocketChannel.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindServerSocket(InetAddress inetAddr) throws IOException {
        while (true) {
            int port = HBaseTestingUtility.randomFreePort();
            InetSocketAddress addr = new InetSocketAddress(inetAddr, port);
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket();
                serverSocket.bind(addr);
                break;
            }
            catch (BindException ex) {}
            continue;
            finally {
                if (serverSocket == null) continue;
                serverSocket.close();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindNIOServerSocket(InetAddress inetAddr) throws IOException {
        while (true) {
            int port = HBaseTestingUtility.randomFreePort();
            InetSocketAddress addr = new InetSocketAddress(inetAddr, port);
            ServerSocketChannel channel = null;
            ServerSocket serverSocket = null;
            try {
                channel = ServerSocketChannel.open();
                serverSocket = channel.socket();
                serverSocket.bind(addr);
                break;
            }
            catch (BindException ex) {}
            continue;
            finally {
                if (serverSocket != null) {
                    serverSocket.close();
                }
                if (channel == null) continue;
                channel.close();
                continue;
            }
            break;
        }
    }

    @Test
    public void testServerSocket() throws IOException {
        byte[] addr = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        InetAddress inetAddr = InetAddress.getByAddress(addr);
        try {
            this.bindServerSocket(inetAddr);
            this.bindNIOServerSocket(inetAddr);
        }
        catch (SocketException ex) {
            Assert.assertFalse((boolean)ex.getClass().isInstance(BindException.class));
            Assert.assertTrue((boolean)ex.getMessage().toLowerCase().contains("protocol family"));
            LOG.info((Object)"Received expected exception:");
            LOG.info((Object)ex);
            this.ensurePreferIPv4();
        }
    }

    public void ensurePreferIPv4() throws IOException {
        InetAddress[] addrs;
        for (InetAddress addr : addrs = InetAddress.getAllByName("localhost")) {
            LOG.info((Object)("resolved localhost as:" + addr));
            Assert.assertEquals((long)4L, (long)addr.getAddress().length);
        }
    }

    @Test
    public void testServerSocketFromLocalhostResolution() throws IOException {
        InetAddress[] addrs;
        for (InetAddress addr : addrs = InetAddress.getAllByName("localhost")) {
            LOG.info((Object)("resolved localhost as:" + addr));
            this.bindServerSocket(addr);
            this.bindNIOServerSocket(addr);
        }
    }

    public static void main(String[] args) throws Exception {
        TestIPv6NIOServerSocketChannel test = new TestIPv6NIOServerSocketChannel();
        test.testServerSocket();
        test.testServerSocketFromLocalhostResolution();
    }
}

